/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.restlet.v1_0;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.CapturedHttpHeaders;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.restlet.v1_0.RestletHeadersGetter;
import io.opentelemetry.instrumentation.restlet.v1_0.RestletHttpAttributesExtractor;
import io.opentelemetry.instrumentation.restlet.v1_0.RestletNetAttributesExtractor;
import io.opentelemetry.instrumentation.restlet.v1_0.RestletTracing;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.Request;
import org.restlet.data.Response;

public final class RestletTracingBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.restlet-1.0";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<Request, Response>> additionalExtractors = new ArrayList<AttributesExtractor<Request, Response>>();
    private CapturedHttpHeaders capturedHttpHeaders = CapturedHttpHeaders.server((Config)Config.get());

    RestletTracingBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    public RestletTracingBuilder addAttributesExtractor(AttributesExtractor<Request, Response> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    public RestletTracingBuilder captureHttpHeaders(CapturedHttpHeaders capturedHttpHeaders) {
        this.capturedHttpHeaders = capturedHttpHeaders;
        return this;
    }

    public RestletTracing build() {
        RestletHttpAttributesExtractor httpAttributesExtractor = new RestletHttpAttributesExtractor(this.capturedHttpHeaders);
        SpanNameExtractor spanNameExtractor = HttpSpanNameExtractor.create((HttpCommonAttributesExtractor)httpAttributesExtractor);
        SpanStatusExtractor spanStatusExtractor = HttpSpanStatusExtractor.create((HttpServerAttributesExtractor)httpAttributesExtractor);
        RestletNetAttributesExtractor netAttributesExtractor = new RestletNetAttributesExtractor();
        Instrumenter instrumenter = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)spanNameExtractor).setSpanStatusExtractor(spanStatusExtractor).addAttributesExtractor((AttributesExtractor)httpAttributesExtractor).addAttributesExtractor((AttributesExtractor)netAttributesExtractor).addAttributesExtractors(this.additionalExtractors).addRequestMetrics(HttpServerMetrics.get()).newServerInstrumenter((TextMapGetter)RestletHeadersGetter.INSTANCE);
        return new RestletTracing((Instrumenter<Request, Response>)instrumenter);
    }
}

