/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.restlet.v1_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.server.ServerSpanNaming;
import org.restlet.Filter;
import org.restlet.data.Request;
import org.restlet.data.Response;

final class TracingFilter
extends Filter {
    private final Instrumenter<Request, Response> instrumenter;
    private final String path;

    public TracingFilter(Instrumenter<Request, Response> instrumenter, String path) {
        this.instrumenter = instrumenter;
        this.path = path;
    }

    public int doHandle(Request request, Response response) {
        Context parentContext;
        Context context = parentContext = Context.current();
        Scope scope = null;
        if (this.instrumenter.shouldStart(parentContext, (Object)request)) {
            context = this.instrumenter.start(parentContext, (Object)request);
            scope = context.makeCurrent();
        }
        ServerSpanNaming.updateServerSpanName((Context)context, (ServerSpanNaming.Source)ServerSpanNaming.Source.CONTROLLER, (ctx, s) -> s, (Object)this.path);
        Throwable statusThrowable = null;
        try {
            super.doHandle(request, response);
        }
        catch (Throwable t) {
            statusThrowable = t;
        }
        if (scope == null) {
            return 0;
        }
        scope.close();
        if (response.getStatus() != null && response.getStatus().isError()) {
            statusThrowable = response.getStatus().getThrowable();
        }
        this.instrumenter.end(context, (Object)request, (Object)response, statusThrowable);
        return 0;
    }
}

