/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.restlet.v1_0;

import io.opentelemetry.instrumentation.api.instrumenter.http.CapturedHttpHeaders;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.restlet.v1_0.RestletHeadersGetter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.restlet.data.Form;
import org.restlet.data.Message;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.util.Series;

final class RestletHttpAttributesExtractor
extends HttpServerAttributesExtractor<Request, Response> {
    RestletHttpAttributesExtractor(CapturedHttpHeaders capturedHttpHeaders) {
        super(capturedHttpHeaders);
    }

    protected String method(Request request) {
        return request.getMethod().toString();
    }

    @Nullable
    protected String target(Request request) {
        Reference ref = request.getOriginalRef();
        String path = ref.getPath();
        return ref.hasQuery() ? path + "?" + ref.getQuery() : path;
    }

    @Nullable
    protected String route(Request request) {
        return null;
    }

    @Nullable
    protected String scheme(Request request) {
        return request.getOriginalRef().getScheme();
    }

    protected List<String> requestHeader(Request request, String name) {
        Form headers = RestletHeadersGetter.getHeaders((Message)request);
        if (headers == null) {
            return Collections.emptyList();
        }
        return RestletHttpAttributesExtractor.parametersToList((Series<Parameter>)headers.subList(name, true));
    }

    @Nullable
    protected Long requestContentLength(Request request, @Nullable Response response) {
        return null;
    }

    @Nullable
    protected Long requestContentLengthUncompressed(Request request, @Nullable Response response) {
        return null;
    }

    @Nullable
    protected String flavor(Request request) {
        String version;
        switch (version = (String)request.getAttributes().get("org.restlet.http.version")) {
            case "HTTP/1.0": {
                return "1.0";
            }
            case "HTTP/1.1": {
                return "1.1";
            }
            case "HTTP/2.0": {
                return "2.0";
            }
        }
        return null;
    }

    @Nullable
    protected String serverName(Request request, @Nullable Response response) {
        return null;
    }

    protected Integer statusCode(Request request, Response response) {
        return response.getStatus().getCode();
    }

    @Nullable
    protected Long responseContentLength(Request request, Response response) {
        return null;
    }

    @Nullable
    protected Long responseContentLengthUncompressed(Request request, Response response) {
        return null;
    }

    protected List<String> responseHeader(Request request, Response response, String name) {
        Form headers = RestletHeadersGetter.getHeaders((Message)response);
        if (headers == null) {
            return Collections.emptyList();
        }
        return RestletHttpAttributesExtractor.parametersToList((Series<Parameter>)headers.subList(name, true));
    }

    private static List<String> parametersToList(Series<Parameter> headers) {
        if (headers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> stringHeaders = new ArrayList<String>(headers.size());
        for (Parameter header : headers) {
            stringHeaders.add(header.getValue());
        }
        return stringHeaders;
    }
}

