/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.restlet.v1_0;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.restlet.v1_0.RestletTracingBuilder;
import io.opentelemetry.instrumentation.restlet.v1_0.TracingFilter;
import org.restlet.Filter;
import org.restlet.data.Request;
import org.restlet.data.Response;

public final class RestletTracing {
    private final Instrumenter<Request, Response> serverInstrumenter;

    public static RestletTracing create(OpenTelemetry openTelemetry) {
        return RestletTracing.builder(openTelemetry).build();
    }

    public static RestletTracingBuilder builder(OpenTelemetry openTelemetry) {
        return new RestletTracingBuilder(openTelemetry);
    }

    RestletTracing(Instrumenter<Request, Response> serverInstrumenter) {
        this.serverInstrumenter = serverInstrumenter;
    }

    public Filter newFilter(String path) {
        return new TracingFilter(this.serverInstrumenter, path);
    }

    public Instrumenter<Request, Response> getServerInstrumenter() {
        return this.serverInstrumenter;
    }
}

