/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.restlet.v1_1;

import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.restlet.v1_1.RestletHeadersGetter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.restlet.data.Form;
import org.restlet.data.Message;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.util.Series;

enum RestletHttpAttributesGetter implements HttpServerAttributesGetter<Request, Response>
{
    INSTANCE;


    public String method(Request request) {
        return request.getMethod().toString();
    }

    @Nullable
    public String target(Request request) {
        Reference ref = request.getOriginalRef();
        String path = ref.getPath();
        return ref.hasQuery() ? path + "?" + ref.getQuery() : path;
    }

    @Nullable
    public String route(Request request) {
        return null;
    }

    @Nullable
    public String scheme(Request request) {
        return request.getOriginalRef().getScheme();
    }

    public List<String> requestHeader(Request request, String name) {
        Form headers = RestletHeadersGetter.getHeaders((Message)request);
        if (headers == null) {
            return Collections.emptyList();
        }
        return RestletHttpAttributesGetter.parametersToList((Series<Parameter>)headers.subList(name, true));
    }

    @Nullable
    public String flavor(Request request) {
        String version;
        switch (version = (String)request.getAttributes().get("org.restlet.http.version")) {
            case "HTTP/1.0": {
                return "1.0";
            }
            case "HTTP/1.1": {
                return "1.1";
            }
            case "HTTP/2.0": {
                return "2.0";
            }
        }
        return null;
    }

    public Integer statusCode(Request request, Response response, @Nullable Throwable error) {
        return response.getStatus().getCode();
    }

    public List<String> responseHeader(Request request, Response response, String name) {
        Form headers = RestletHeadersGetter.getHeaders((Message)response);
        if (headers == null) {
            return Collections.emptyList();
        }
        return RestletHttpAttributesGetter.parametersToList((Series<Parameter>)headers.subList(name, true));
    }

    private static List<String> parametersToList(Series<Parameter> headers) {
        if (headers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> stringHeaders = new ArrayList<String>(headers.size());
        for (Parameter header : headers) {
            stringHeaders.add(header.getValue());
        }
        return stringHeaders;
    }
}

