/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.restlet.v1_1;

import com.noelios.restlet.http.HttpCall;
import com.noelios.restlet.http.HttpRequest;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import javax.annotation.Nullable;
import org.restlet.data.Request;

final class RestletNetAttributesGetter
implements NetServerAttributesGetter<Request> {
    RestletNetAttributesGetter() {
    }

    public String transport(Request request) {
        return "ip_tcp";
    }

    @Nullable
    public String hostName(Request request) {
        HttpCall call = RestletNetAttributesGetter.httpCall(request);
        return call == null ? null : call.getHostDomain();
    }

    @Nullable
    public Integer hostPort(Request request) {
        HttpCall call = RestletNetAttributesGetter.httpCall(request);
        return call == null ? null : Integer.valueOf(call.getServerPort());
    }

    @Nullable
    public String sockPeerAddr(Request request) {
        return request.getClientInfo().getAddress();
    }

    public Integer sockPeerPort(Request request) {
        return request.getClientInfo().getPort();
    }

    @Nullable
    public String sockHostAddr(Request request) {
        HttpCall call = RestletNetAttributesGetter.httpCall(request);
        return call == null ? null : call.getServerAddress();
    }

    @Nullable
    private static HttpCall httpCall(Request request) {
        if (request instanceof HttpRequest) {
            return ((HttpRequest)request).getHttpCall();
        }
        return null;
    }
}

