/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.restlet.v1_1;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.restlet.v1_1.RestletTelemetryBuilder;
import io.opentelemetry.instrumentation.restlet.v1_1.TracingFilter;
import org.restlet.Filter;
import org.restlet.data.Request;
import org.restlet.data.Response;

public final class RestletTelemetry {
    private final Instrumenter<Request, Response> serverInstrumenter;

    public static RestletTelemetry create(OpenTelemetry openTelemetry) {
        return RestletTelemetry.builder(openTelemetry).build();
    }

    public static RestletTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new RestletTelemetryBuilder(openTelemetry);
    }

    RestletTelemetry(Instrumenter<Request, Response> serverInstrumenter) {
        this.serverInstrumenter = serverInstrumenter;
    }

    public Filter newFilter(String path) {
        return new TracingFilter(this.serverInstrumenter, path);
    }

    public Instrumenter<Request, Response> getServerInstrumenter() {
        return this.serverInstrumenter;
    }
}

