/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.restlet.v1_1;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.instrumentation.restlet.v1_1.RestletHeadersGetter;
import io.opentelemetry.instrumentation.restlet.v1_1.RestletHttpAttributesGetter;
import io.opentelemetry.instrumentation.restlet.v1_1.RestletNetAttributesGetter;
import io.opentelemetry.instrumentation.restlet.v1_1.RestletTelemetry;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.Request;
import org.restlet.data.Response;

public final class RestletTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.restlet-1.1";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<Request, Response>> additionalExtractors = new ArrayList<AttributesExtractor<Request, Response>>();
    private final HttpServerAttributesExtractorBuilder<Request, Response> httpAttributesExtractorBuilder = HttpServerAttributesExtractor.builder((HttpServerAttributesGetter)RestletHttpAttributesGetter.INSTANCE, (NetServerAttributesGetter)new RestletNetAttributesGetter());

    RestletTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public RestletTelemetryBuilder addAttributesExtractor(AttributesExtractor<Request, Response> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public RestletTelemetryBuilder setCapturedRequestHeaders(List<String> requestHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public RestletTelemetryBuilder setCapturedResponseHeaders(List<String> responseHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    public RestletTelemetry build() {
        RestletHttpAttributesGetter httpAttributesGetter = RestletHttpAttributesGetter.INSTANCE;
        Instrumenter instrumenter = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)httpAttributesGetter)).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)httpAttributesGetter)).addAttributesExtractor((AttributesExtractor)this.httpAttributesExtractorBuilder.build()).addAttributesExtractors(this.additionalExtractors).addOperationMetrics(HttpServerMetrics.get()).buildServerInstrumenter((TextMapGetter)RestletHeadersGetter.INSTANCE);
        return new RestletTelemetry((Instrumenter<Request, Response>)instrumenter);
    }
}

