/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.restlet.v2_0;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.instrumentation.restlet.v2_0.RestletTelemetry;
import io.opentelemetry.instrumentation.restlet.v2_0.internal.RestletHttpAttributesGetter;
import io.opentelemetry.instrumentation.restlet.v2_0.internal.RestletInstrumenterFactory;
import io.opentelemetry.instrumentation.restlet.v2_0.internal.RestletNetAttributesGetter;
import java.util.ArrayList;
import java.util.List;
import org.restlet.Request;
import org.restlet.Response;

public final class RestletTelemetryBuilder {
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<Request, Response>> additionalExtractors = new ArrayList<AttributesExtractor<Request, Response>>();
    private final HttpServerAttributesExtractorBuilder<Request, Response> httpAttributesExtractorBuilder = HttpServerAttributesExtractor.builder((HttpServerAttributesGetter)RestletHttpAttributesGetter.INSTANCE, (NetServerAttributesGetter)new RestletNetAttributesGetter());

    RestletTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public RestletTelemetryBuilder addAttributesExtractor(AttributesExtractor<Request, Response> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public RestletTelemetryBuilder setCapturedRequestHeaders(List<String> requestHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public RestletTelemetryBuilder setCapturedResponseHeaders(List<String> responseHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    public RestletTelemetry build() {
        Instrumenter<Request, Response> serverInstrumenter = RestletInstrumenterFactory.newServerInstrumenter(this.openTelemetry, (AttributesExtractor<Request, Response>)this.httpAttributesExtractorBuilder.build(), this.additionalExtractors);
        return new RestletTelemetry(serverInstrumenter);
    }
}

