/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.restlet.v2_0.internal;

import io.opentelemetry.context.propagation.TextMapGetter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.restlet.Message;
import org.restlet.Request;
import org.restlet.util.Series;

final class RestletHeadersGetter
implements TextMapGetter<Request> {
    private static final MethodHandle GET_ATTRIBUTES;

    RestletHeadersGetter() {
    }

    public Iterable<String> keys(Request carrier) {
        Series<?> headers = RestletHeadersGetter.getHeaders((Message)carrier);
        return headers == null ? Collections.emptySet() : headers.getNames();
    }

    public String get(Request carrier, String key) {
        Series<?> headers = RestletHeadersGetter.getHeaders((Message)carrier);
        return headers == null ? null : headers.getFirstValue(key, true);
    }

    @Nullable
    static Series<?> getHeaders(Message carrier) {
        if (GET_ATTRIBUTES == null) {
            return null;
        }
        try {
            Map attributes = GET_ATTRIBUTES.invoke(carrier);
            return (Series)attributes.get("org.restlet.http.headers");
        }
        catch (Throwable e) {
            return null;
        }
    }

    static {
        MethodHandle getAttributes = null;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            getAttributes = lookup.findVirtual(Message.class, "getAttributes", MethodType.methodType(Map.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            try {
                getAttributes = lookup.findVirtual(Message.class, "getAttributes", MethodType.methodType(ConcurrentMap.class));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        GET_ATTRIBUTES = getAttributes;
    }
}

