/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.restlet.v2_0.internal;

import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.restlet.v2_0.internal.RestletHeadersGetter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.restlet.Message;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Reference;
import org.restlet.util.Series;

public enum RestletHttpAttributesGetter implements HttpServerAttributesGetter<Request, Response>
{
    INSTANCE;


    public String getMethod(Request request) {
        return request.getMethod().toString();
    }

    @Nullable
    public String getTarget(Request request) {
        Reference ref = request.getOriginalRef();
        String path = ref.getPath();
        return ref.hasQuery() ? path + "?" + ref.getQuery() : path;
    }

    @Nullable
    public String getScheme(Request request) {
        return request.getOriginalRef().getScheme();
    }

    public List<String> getRequestHeader(Request request, String name) {
        Series<?> headers = RestletHeadersGetter.getHeaders((Message)request);
        if (headers == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(headers.getValuesArray(name, true));
    }

    public Integer getStatusCode(Request request, Response response, @Nullable Throwable error) {
        return response.getStatus().getCode();
    }

    public List<String> getResponseHeader(Request request, Response response, String name) {
        Series<?> headers = RestletHeadersGetter.getHeaders((Message)response);
        if (headers == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(headers.getValuesArray(name, true));
    }
}

