/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.restlet.v2_0.internal;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpRouteHolder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.restlet.v2_0.internal.RestletHeadersGetter;
import io.opentelemetry.instrumentation.restlet.v2_0.internal.RestletHttpAttributesGetter;
import java.util.List;
import org.restlet.Request;
import org.restlet.Response;

public final class RestletInstrumenterFactory {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.restlet-2.0";

    public static Instrumenter<Request, Response> newServerInstrumenter(OpenTelemetry openTelemetry, AttributesExtractor<Request, Response> httpServerAttributesExtractor, List<AttributesExtractor<Request, Response>> additionalExtractors) {
        RestletHttpAttributesGetter httpAttributesGetter = RestletHttpAttributesGetter.INSTANCE;
        return Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)httpAttributesGetter)).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)httpAttributesGetter)).addAttributesExtractor(httpServerAttributesExtractor).addAttributesExtractors(additionalExtractors).addOperationMetrics(HttpServerMetrics.get()).addContextCustomizer(HttpRouteHolder.create((HttpServerAttributesGetter)httpAttributesGetter)).buildServerInstrumenter((TextMapGetter)new RestletHeadersGetter());
    }

    private RestletInstrumenterFactory() {
    }
}

