/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.restlet.v2_0;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.builder.internal.DefaultHttpServerInstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.restlet.v2_0.RestletTelemetry;
import io.opentelemetry.instrumentation.restlet.v2_0.internal.Experimental;
import io.opentelemetry.instrumentation.restlet.v2_0.internal.RestletTelemetryBuilderFactory;
import java.util.Collection;
import java.util.function.Function;
import org.restlet.Request;
import org.restlet.Response;

public final class RestletTelemetryBuilder {
    private final DefaultHttpServerInstrumenterBuilder<Request, Response> builder;

    RestletTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.builder = RestletTelemetryBuilderFactory.create(openTelemetry);
    }

    @CanIgnoreReturnValue
    public RestletTelemetryBuilder addAttributesExtractor(AttributesExtractor<Request, Response> attributesExtractor) {
        this.builder.addAttributesExtractor(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public RestletTelemetryBuilder setCapturedRequestHeaders(Collection<String> requestHeaders) {
        this.builder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public RestletTelemetryBuilder setCapturedResponseHeaders(Collection<String> responseHeaders) {
        this.builder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public RestletTelemetryBuilder setKnownMethods(Collection<String> knownMethods) {
        this.builder.setKnownMethods(knownMethods);
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public RestletTelemetryBuilder setEmitExperimentalHttpServerMetrics(boolean emitExperimentalHttpServerMetrics) {
        this.builder.setEmitExperimentalHttpServerMetrics(emitExperimentalHttpServerMetrics);
        return this;
    }

    @CanIgnoreReturnValue
    public RestletTelemetryBuilder setSpanNameExtractor(Function<SpanNameExtractor<? super Request>, ? extends SpanNameExtractor<? super Request>> spanNameExtractorTransformer) {
        this.builder.setSpanNameExtractor(spanNameExtractorTransformer);
        return this;
    }

    public RestletTelemetry build() {
        return new RestletTelemetry((Instrumenter<Request, Response>)this.builder.build());
    }

    static {
        Experimental.internalSetEmitExperimentalTelemetry((builder, emit) -> builder.builder.setEmitExperimentalHttpServerMetrics(emit.booleanValue()));
    }
}

