/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.restlet.v2_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerRoute;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerRouteSource;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.resource.ResourceException;
import org.restlet.routing.Filter;

final class TracingFilter
extends Filter {
    private final Instrumenter<Request, Response> instrumenter;
    private final String path;

    public TracingFilter(Instrumenter<Request, Response> instrumenter, String path) {
        this.instrumenter = instrumenter;
        this.path = path;
    }

    public int doHandle(Request request, Response response) {
        Context parentContext;
        Context context = parentContext = Context.current();
        Scope scope = null;
        if (this.instrumenter.shouldStart(parentContext, (Object)request)) {
            context = this.instrumenter.start(parentContext, (Object)request);
            scope = context.makeCurrent();
        }
        HttpServerRoute.update((Context)context, (HttpServerRouteSource)HttpServerRouteSource.CONTROLLER, (String)this.path);
        Throwable statusThrowable = null;
        try {
            super.doHandle(request, response);
        }
        catch (Throwable t) {
            statusThrowable = t;
            if (t instanceof Error || t instanceof RuntimeException) {
                throw t;
            }
            throw new ResourceException(t);
        }
        finally {
            if (scope != null) {
                scope.close();
                if (response.getStatus() != null && response.getStatus().isError()) {
                    statusThrowable = response.getStatus().getThrowable();
                }
                this.instrumenter.end(context, (Object)request, (Object)response, statusThrowable);
            }
        }
        return 0;
    }
}

