/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.restlet.v2_0;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerRoute;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerRouteBuilder;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractorBuilder;
import io.opentelemetry.instrumentation.restlet.v2_0.RestletTelemetry;
import io.opentelemetry.instrumentation.restlet.v2_0.internal.RestletHttpAttributesGetter;
import io.opentelemetry.instrumentation.restlet.v2_0.internal.RestletInstrumenterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.restlet.Request;
import org.restlet.Response;

public final class RestletTelemetryBuilder {
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<Request, Response>> additionalExtractors = new ArrayList<AttributesExtractor<Request, Response>>();
    private final HttpServerAttributesExtractorBuilder<Request, Response> httpAttributesExtractorBuilder = HttpServerAttributesExtractor.builder((HttpServerAttributesGetter)RestletHttpAttributesGetter.INSTANCE);
    private final HttpSpanNameExtractorBuilder<Request> httpSpanNameExtractorBuilder = HttpSpanNameExtractor.builder((HttpServerAttributesGetter)RestletHttpAttributesGetter.INSTANCE);
    private Function<SpanNameExtractor<Request>, ? extends SpanNameExtractor<? super Request>> spanNameExtractorTransformer = Function.identity();
    private final HttpServerRouteBuilder<Request> httpServerRouteBuilder = HttpServerRoute.builder((HttpServerAttributesGetter)RestletHttpAttributesGetter.INSTANCE);
    private boolean emitExperimentalHttpServerMetrics = false;

    RestletTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public RestletTelemetryBuilder addAttributesExtractor(AttributesExtractor<Request, Response> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public RestletTelemetryBuilder setCapturedRequestHeaders(List<String> requestHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public RestletTelemetryBuilder setCapturedResponseHeaders(List<String> responseHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public RestletTelemetryBuilder setKnownMethods(Set<String> knownMethods) {
        this.httpAttributesExtractorBuilder.setKnownMethods(knownMethods);
        this.httpSpanNameExtractorBuilder.setKnownMethods(knownMethods);
        this.httpServerRouteBuilder.setKnownMethods(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    public RestletTelemetryBuilder setEmitExperimentalHttpServerMetrics(boolean emitExperimentalHttpServerMetrics) {
        this.emitExperimentalHttpServerMetrics = emitExperimentalHttpServerMetrics;
        return this;
    }

    @CanIgnoreReturnValue
    public RestletTelemetryBuilder setSpanNameExtractor(Function<SpanNameExtractor<Request>, ? extends SpanNameExtractor<? super Request>> spanNameExtractorTransformer) {
        this.spanNameExtractorTransformer = spanNameExtractorTransformer;
        return this;
    }

    public RestletTelemetry build() {
        SpanNameExtractor<? super Request> spanNameExtractor = this.spanNameExtractorTransformer.apply((SpanNameExtractor<Request>)this.httpSpanNameExtractorBuilder.build());
        Instrumenter<Request, Response> serverInstrumenter = RestletInstrumenterFactory.newServerInstrumenter(this.openTelemetry, (AttributesExtractor<Request, Response>)this.httpAttributesExtractorBuilder.build(), spanNameExtractor, (ContextCustomizer<Request>)this.httpServerRouteBuilder.build(), this.additionalExtractors, this.emitExperimentalHttpServerMetrics);
        return new RestletTelemetry(serverInstrumenter);
    }
}

