/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.restlet.v2_0.internal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.restlet.Message;
import org.restlet.data.Form;
import org.restlet.util.Series;

public final class MessageAttributesAccessor {
    private static final MethodHandle GET_ATTRIBUTES;
    private static final MethodHandle SET_VALUE;
    private static final Class<?> HEADER_CLASS;
    private static final MethodHandle NEW_SERIES;

    @Nullable
    public static Map<String, Object> getAttributes(Message message) {
        if (GET_ATTRIBUTES == null) {
            return null;
        }
        try {
            return GET_ATTRIBUTES.invoke(message);
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Nullable
    public static Series<?> createHeaderSeries() {
        if (HEADER_CLASS == null) {
            return new Form();
        }
        if (NEW_SERIES == null) {
            return null;
        }
        try {
            return NEW_SERIES.invoke(HEADER_CLASS);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static void setSeriesValue(Series<?> series, String name, String value) {
        if (SET_VALUE == null) {
            return;
        }
        try {
            SET_VALUE.invoke(series, name, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private MessageAttributesAccessor() {
    }

    static {
        MethodHandle getAttributes = null;
        MethodHandle setValue = null;
        Class<?> headerClass = null;
        MethodHandle newSeries = null;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            getAttributes = lookup.findVirtual(Message.class, "getAttributes", MethodType.methodType(Map.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            try {
                getAttributes = lookup.findVirtual(Message.class, "getAttributes", MethodType.methodType(ConcurrentMap.class));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        Class<?> setValueReturnType = null;
        try {
            setValueReturnType = Class.forName("org.restlet.util.NamedValue");
        }
        catch (ClassNotFoundException e) {
            try {
                setValueReturnType = Class.forName("org.restlet.data.Parameter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (setValueReturnType != null) {
            try {
                setValue = lookup.findVirtual(Series.class, "set", MethodType.methodType(setValueReturnType, String.class, String.class));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                // empty catch block
            }
        }
        try {
            headerClass = Class.forName("org.restlet.data.Header");
        }
        catch (ClassNotFoundException e) {
            try {
                headerClass = Class.forName("org.restlet.engine.header.Header");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (headerClass != null) {
            try {
                newSeries = lookup.findConstructor(Series.class, MethodType.methodType(Void.TYPE, Class.class));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        GET_ATTRIBUTES = getAttributes;
        SET_VALUE = setValue;
        HEADER_CLASS = headerClass;
        NEW_SERIES = newSeries;
    }
}

