/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.restlet.v2_0.internal;

import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.restlet.v2_0.internal.RestletHeadersGetter;
import io.opentelemetry.instrumentation.restlet.v2_0.internal.ServerCallAccess;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.restlet.Message;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.util.Series;

public enum RestletHttpAttributesGetter implements HttpServerAttributesGetter<Request, Response>
{
    INSTANCE;


    public String getHttpRequestMethod(Request request) {
        return request.getMethod().toString();
    }

    @Nullable
    public String getUrlScheme(Request request) {
        return request.getOriginalRef().getScheme();
    }

    @Nullable
    public String getUrlPath(Request request) {
        return request.getOriginalRef().getPath();
    }

    @Nullable
    public String getUrlQuery(Request request) {
        return request.getOriginalRef().getQuery();
    }

    public List<String> getHttpRequestHeader(Request request, String name) {
        Series<?> headers = RestletHeadersGetter.getHeaders((Message)request);
        if (headers == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(headers.getValuesArray(name, true));
    }

    public Integer getHttpResponseStatusCode(Request request, Response response, @Nullable Throwable error) {
        return response.getStatus().getCode();
    }

    public List<String> getHttpResponseHeader(Request request, Response response, String name) {
        Series<?> headers = RestletHeadersGetter.getHeaders((Message)response);
        if (headers == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(headers.getValuesArray(name, true));
    }

    @Nullable
    public String getNetworkProtocolName(Request request, @Nullable Response response) {
        return request.getProtocol().getSchemeName();
    }

    @Nullable
    public String getNetworkProtocolVersion(Request request, @Nullable Response response) {
        return request.getProtocol().getVersion();
    }

    @Nullable
    public String getNetworkPeerAddress(Request request, @Nullable Response response) {
        return request.getClientInfo().getAddress();
    }

    public Integer getNetworkPeerPort(Request request, @Nullable Response response) {
        return request.getClientInfo().getPort();
    }

    @Nullable
    public String getNetworkLocalAddress(Request request, @Nullable Response response) {
        return ServerCallAccess.getServerAddress(request);
    }
}

