/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.restlet.v2_0.internal;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpServerExperimentalMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerMetrics;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.restlet.v2_0.internal.RestletHeadersGetter;
import io.opentelemetry.instrumentation.restlet.v2_0.internal.RestletHttpAttributesGetter;
import java.util.List;
import org.restlet.Request;
import org.restlet.Response;

public final class RestletInstrumenterFactory {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.restlet-2.0";

    public static Instrumenter<Request, Response> newServerInstrumenter(OpenTelemetry openTelemetry, AttributesExtractor<Request, Response> httpServerAttributesExtractor, SpanNameExtractor<? super Request> httpServerSpanNameExtractor, ContextCustomizer<Request> httpServerRoute, List<AttributesExtractor<Request, Response>> additionalExtractors, boolean emitExperimentalHttpServerMetrics) {
        RestletHttpAttributesGetter httpAttributesGetter = RestletHttpAttributesGetter.INSTANCE;
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, httpServerSpanNameExtractor).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)httpAttributesGetter)).addAttributesExtractor(httpServerAttributesExtractor).addAttributesExtractors(additionalExtractors).addContextCustomizer(httpServerRoute).addOperationMetrics(HttpServerMetrics.get());
        if (emitExperimentalHttpServerMetrics) {
            builder.addAttributesExtractor(HttpExperimentalAttributesExtractor.create((HttpServerAttributesGetter)httpAttributesGetter)).addOperationMetrics(HttpServerExperimentalMetrics.get());
        }
        return builder.buildServerInstrumenter((TextMapGetter)new RestletHeadersGetter());
    }

    private RestletInstrumenterFactory() {
    }
}

