/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.restlet.v2_0.internal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.annotation.Nullable;
import org.restlet.Request;

final class ServerCallAccess {
    private static final Class<?> HTTP_REQUEST_CLASS;
    private static final MethodHandle GET_HTTP_CALL;
    private static final MethodHandle GET_SERVER_ADDRESS;

    @Nullable
    static String getServerAddress(Request request) {
        if (GET_SERVER_ADDRESS == null) {
            return null;
        }
        Object call = ServerCallAccess.serverCall(request);
        if (call == null) {
            return null;
        }
        try {
            return GET_SERVER_ADDRESS.invoke(call);
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Nullable
    private static Object serverCall(Request request) {
        if (GET_HTTP_CALL == null || HTTP_REQUEST_CLASS == null) {
            return null;
        }
        if (HTTP_REQUEST_CLASS.isInstance(request)) {
            try {
                return GET_HTTP_CALL.invoke(request);
            }
            catch (Throwable e) {
                return null;
            }
        }
        return null;
    }

    private ServerCallAccess() {
    }

    static {
        Class<?> httpRequestClass = null;
        Class<?> serverCallClass = null;
        MethodHandle getHttpCall = null;
        MethodHandle getServerAddress = null;
        try {
            httpRequestClass = Class.forName("org.restlet.engine.http.HttpRequest");
        }
        catch (ClassNotFoundException e) {
            try {
                httpRequestClass = Class.forName("org.restlet.engine.adapter.HttpRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            serverCallClass = Class.forName("org.restlet.engine.http.ServerCall");
        }
        catch (ClassNotFoundException e) {
            try {
                serverCallClass = Class.forName("org.restlet.engine.adapter.ServerCall");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (httpRequestClass != null && serverCallClass != null) {
            try {
                MethodHandles.Lookup lookup = MethodHandles.publicLookup();
                getHttpCall = lookup.findVirtual(httpRequestClass, "getHttpCall", MethodType.methodType(serverCallClass));
                getServerAddress = lookup.findVirtual(serverCallClass, "getServerAddress", MethodType.methodType(String.class));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        HTTP_REQUEST_CLASS = httpRequestClass;
        GET_HTTP_CALL = getHttpCall;
        GET_SERVER_ADDRESS = getServerAddress;
    }
}

