/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;

public final class MemoryPools {
    static final AttributeKey<String> TYPE_KEY = AttributeKey.stringKey((String)"type");
    static final AttributeKey<String> AREA_KEY = AttributeKey.stringKey((String)"area");
    private static final AttributeKey<String> POOL_KEY = AttributeKey.stringKey((String)"pool");
    private static final String USED = "used";
    private static final String COMMITTED = "committed";
    private static final String MAX = "max";
    private static final String HEAP = "heap";
    private static final String NON_HEAP = "non_heap";
    private static final Attributes COMMITTED_HEAP = Attributes.of(TYPE_KEY, (Object)"committed", AREA_KEY, (Object)"heap");
    private static final Attributes USED_HEAP = Attributes.of(TYPE_KEY, (Object)"used", AREA_KEY, (Object)"heap");
    private static final Attributes MAX_HEAP = Attributes.of(TYPE_KEY, (Object)"max", AREA_KEY, (Object)"heap");
    private static final Attributes COMMITTED_NON_HEAP = Attributes.of(TYPE_KEY, (Object)"committed", AREA_KEY, (Object)"non_heap");
    private static final Attributes USED_NON_HEAP = Attributes.of(TYPE_KEY, (Object)"used", AREA_KEY, (Object)"non_heap");
    private static final Attributes MAX_NON_HEAP = Attributes.of(TYPE_KEY, (Object)"max", AREA_KEY, (Object)"non_heap");

    public static void registerMemoryAreaObservers() {
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        Meter meter = GlobalMeterProvider.get().get(MemoryPools.class.getName());
        meter.gaugeBuilder("runtime.jvm.memory.area").ofLongs().setDescription("Bytes of a given JVM memory area.").setUnit("By").buildWithCallback(resultLongObserver -> {
            MemoryPools.observeHeap(resultLongObserver, memoryBean.getHeapMemoryUsage());
            MemoryPools.observeNonHeap(resultLongObserver, memoryBean.getNonHeapMemoryUsage());
        });
    }

    public static void registerMemoryPoolObservers() {
        List<MemoryPoolMXBean> poolBeans = ManagementFactory.getMemoryPoolMXBeans();
        Meter meter = GlobalMeterProvider.get().get(MemoryPools.class.getName());
        ArrayList<Attributes> usedLabelSets = new ArrayList<Attributes>(poolBeans.size());
        ArrayList<Attributes> committedLabelSets = new ArrayList<Attributes>(poolBeans.size());
        ArrayList<Attributes> maxLabelSets = new ArrayList<Attributes>(poolBeans.size());
        for (MemoryPoolMXBean pool : poolBeans) {
            usedLabelSets.add(Attributes.of(TYPE_KEY, (Object)USED, POOL_KEY, (Object)pool.getName()));
            committedLabelSets.add(Attributes.of(TYPE_KEY, (Object)COMMITTED, POOL_KEY, (Object)pool.getName()));
            maxLabelSets.add(Attributes.of(TYPE_KEY, (Object)MAX, POOL_KEY, (Object)pool.getName()));
        }
        meter.gaugeBuilder("runtime.jvm.memory.pool").ofLongs().setDescription("Bytes of a given JVM memory pool.").setUnit("By").buildWithCallback(resultLongObserver -> {
            for (int i = 0; i < poolBeans.size(); ++i) {
                MemoryUsage poolUsage = ((MemoryPoolMXBean)poolBeans.get(i)).getUsage();
                if (poolUsage == null) continue;
                MemoryPools.observe(resultLongObserver, poolUsage, (Attributes)usedLabelSets.get(i), (Attributes)committedLabelSets.get(i), (Attributes)maxLabelSets.get(i));
            }
        });
    }

    public static void registerObservers() {
        MemoryPools.registerMemoryAreaObservers();
        MemoryPools.registerMemoryPoolObservers();
    }

    static void observeHeap(ObservableLongMeasurement measurement, MemoryUsage usage) {
        MemoryPools.observe(measurement, usage, USED_HEAP, COMMITTED_HEAP, MAX_HEAP);
    }

    static void observeNonHeap(ObservableLongMeasurement measurement, MemoryUsage usage) {
        MemoryPools.observe(measurement, usage, USED_NON_HEAP, COMMITTED_NON_HEAP, MAX_NON_HEAP);
    }

    private static void observe(ObservableLongMeasurement measurement, MemoryUsage usage, Attributes usedAttributes, Attributes committedAttributes, Attributes maxAttributes) {
        measurement.observe(usage.getUsed(), usedAttributes);
        measurement.observe(usage.getCommitted(), committedAttributes);
        if (usage.getMax() != -1L) {
            measurement.observe(usage.getMax(), maxAttributes);
        }
    }

    private MemoryPools() {
    }
}

