/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.rxjava;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.tracer.BaseTracer;
import java.util.concurrent.atomic.AtomicReference;
import rx.Subscription;

public class SpanFinishingSubscription
implements Subscription {
    private final BaseTracer tracer;
    private final AtomicReference<Context> contextRef;

    public SpanFinishingSubscription(BaseTracer tracer, AtomicReference<Context> contextRef) {
        this.tracer = tracer;
        this.contextRef = contextRef;
    }

    public void unsubscribe() {
        Span span;
        Context context = this.contextRef.getAndSet(null);
        if (context != null && (span = Span.fromContext((Context)context)).getSpanContext().isValid()) {
            this.tracer.end(span);
        }
    }

    public boolean isUnsubscribed() {
        return this.contextRef.get() == null;
    }
}

