/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.rxjava;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.tracer.BaseTracer;
import io.opentelemetry.instrumentation.rxjava.TracedSubscriber;
import rx.Observable;
import rx.Subscriber;
import rx.__OpenTelemetryTracingUtil;

public class TracedOnSubscribe<T>
implements Observable.OnSubscribe<T> {
    private final Observable.OnSubscribe<T> delegate;
    private final String operationName;
    private final Context parentContext;
    private final BaseTracer tracer;
    private final Span.Kind spanKind;

    public TracedOnSubscribe(Observable<T> originalObservable, String operationName, BaseTracer tracer, Span.Kind spanKind) {
        this.delegate = __OpenTelemetryTracingUtil.extractOnSubscribe(originalObservable);
        this.operationName = operationName;
        this.tracer = tracer;
        this.spanKind = spanKind;
        this.parentContext = Context.current();
    }

    public void call(Subscriber<? super T> subscriber) {
        try (Scope ignored = this.parentContext.makeCurrent();){
            Span span = this.tracer.startSpan(this.operationName, this.spanKind);
            this.decorateSpan(span);
            try (Scope ignored1 = this.tracer.startScope(span);){
                this.delegate.call(new TracedSubscriber<T>(Context.current(), subscriber, this.tracer));
            }
        }
    }

    protected void decorateSpan(Span span) {
    }
}

