/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.rxjava.v1_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.rxjava.v1_0.SpanFinishingSubscription;
import java.util.concurrent.atomic.AtomicReference;
import rx.Subscriber;

final class TracedSubscriber<T, REQUEST>
extends Subscriber<T> {
    private final Subscriber<T> delegate;
    private final Instrumenter<REQUEST, ?> instrumenter;
    private final AtomicReference<Context> contextRef;
    private final REQUEST request;

    TracedSubscriber(Subscriber<T> delegate, Instrumenter<REQUEST, ?> instrumenter, Context context, REQUEST request) {
        this.delegate = delegate;
        this.instrumenter = instrumenter;
        this.contextRef = new AtomicReference<Context>(context);
        this.request = request;
        delegate.add(new SpanFinishingSubscription<REQUEST>(instrumenter, this.contextRef, request));
    }

    public void onStart() {
        Context context = this.contextRef.get();
        if (context != null) {
            try (Scope ignored = context.makeCurrent();){
                this.delegate.onStart();
            }
        } else {
            this.delegate.onStart();
        }
    }

    public void onNext(T value) {
        Context context = this.contextRef.get();
        if (context != null) {
            try (Scope ignored = context.makeCurrent();){
                this.delegate.onNext(value);
            }
        } else {
            this.delegate.onNext(value);
        }
    }

    public void onCompleted() {
        block12: {
            Context context = this.contextRef.getAndSet(null);
            if (context != null) {
                Throwable error = null;
                try (Scope ignored = context.makeCurrent();){
                    this.delegate.onCompleted();
                    break block12;
                }
                catch (Throwable t) {
                    error = t;
                    throw t;
                }
                finally {
                    this.instrumenter.end(context, this.request, null, error);
                }
            }
            this.delegate.onCompleted();
        }
    }

    public void onError(Throwable e) {
        Context context = this.contextRef.getAndSet(null);
        if (context != null) {
            this.instrumenter.end(context, this.request, null, e);
        }
        this.delegate.onError(e);
    }
}

