/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.rxjava;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.tracer.BaseTracer;
import io.opentelemetry.instrumentation.rxjava.TracedSubscriber;
import rx.Observable;
import rx.Subscriber;
import rx.__OpenTelemetryTracingUtil;

public class TracedOnSubscribe<T>
implements Observable.OnSubscribe<T> {
    private final Observable.OnSubscribe<T> delegate;
    private final String spanName;
    private final Context parentContext;
    private final BaseTracer tracer;
    private final SpanKind spanKind;

    public TracedOnSubscribe(Observable<T> originalObservable, String spanName, BaseTracer tracer, SpanKind spanKind) {
        this.delegate = __OpenTelemetryTracingUtil.extractOnSubscribe(originalObservable);
        this.spanName = spanName;
        this.tracer = tracer;
        this.spanKind = spanKind;
        this.parentContext = Context.current();
    }

    public void call(Subscriber<? super T> subscriber) {
        Context context = this.tracer.startSpan(this.parentContext, this.spanName, this.spanKind);
        this.decorateSpan(Span.fromContext((Context)context));
        try (Scope ignored = context.makeCurrent();){
            this.delegate.call(new TracedSubscriber<T>(context, subscriber, this.tracer));
        }
    }

    protected void decorateSpan(Span span) {
    }
}

