/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.rxjava;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.tracer.BaseTracer;
import io.opentelemetry.instrumentation.rxjava.SpanFinishingSubscription;
import java.util.concurrent.atomic.AtomicReference;
import rx.Subscriber;
import rx.Subscription;

public class TracedSubscriber<T>
extends Subscriber<T> {
    private final AtomicReference<Context> contextRef;
    private final Subscriber<T> delegate;
    private final BaseTracer tracer;

    public TracedSubscriber(Context context, Subscriber<T> delegate, BaseTracer tracer) {
        this.contextRef = new AtomicReference<Context>(context);
        this.delegate = delegate;
        this.tracer = tracer;
        SpanFinishingSubscription subscription = new SpanFinishingSubscription(tracer, this.contextRef);
        delegate.add((Subscription)subscription);
    }

    public void onStart() {
        Context context = this.contextRef.get();
        if (context != null) {
            try (Scope ignored = context.makeCurrent();){
                this.delegate.onStart();
            }
        } else {
            this.delegate.onStart();
        }
    }

    public void onNext(T value) {
        Context context = this.contextRef.get();
        if (context != null) {
            try (Scope ignored = context.makeCurrent();){
                this.delegate.onNext(value);
            }
        } else {
            this.delegate.onNext(value);
        }
    }

    public void onCompleted() {
        block14: {
            Context context = this.contextRef.getAndSet(null);
            if (context != null) {
                Throwable error = null;
                try (Scope ignored = context.makeCurrent();){
                    this.delegate.onCompleted();
                    break block14;
                }
                catch (Throwable t) {
                    error = t;
                    throw t;
                }
                finally {
                    if (error != null) {
                        this.tracer.endExceptionally(context, error);
                    } else {
                        this.tracer.end(context);
                    }
                }
            }
            this.delegate.onCompleted();
        }
    }

    public void onError(Throwable e) {
        Context context = this.contextRef.getAndSet(null);
        if (context != null) {
            this.tracer.endExceptionally(context, e);
        }
        this.delegate.onError(e);
    }
}

