/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.rxjava;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.rxjava.TracedSubscriber;
import rx.Observable;
import rx.Subscriber;
import rx.__OpenTelemetryTracingUtil;

public final class TracedOnSubscribe<T, REQUEST>
implements Observable.OnSubscribe<T> {
    private final Observable.OnSubscribe<T> delegate;
    private final Instrumenter<REQUEST, ?> instrumenter;
    private final REQUEST request;
    private final Context parentContext;

    public TracedOnSubscribe(Observable<T> originalObservable, Instrumenter<REQUEST, ?> instrumenter, REQUEST request) {
        this.delegate = __OpenTelemetryTracingUtil.extractOnSubscribe(originalObservable);
        this.instrumenter = instrumenter;
        this.request = request;
        this.parentContext = Context.current();
    }

    public void call(Subscriber<? super T> subscriber) {
        Context context = this.instrumenter.start(this.parentContext, this.request);
        try (Scope ignored = context.makeCurrent();){
            this.delegate.call(new TracedSubscriber<T, REQUEST>(subscriber, this.instrumenter, context, this.request));
        }
    }
}

