/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.rxjava.v2_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.subscribers.BasicFuseableSubscriber;
import org.reactivestreams.Subscriber;

class TracingSubscriber<T>
extends BasicFuseableSubscriber<T, T> {
    private final Subscriber<? super T> wrappedSubscriber;
    private final Context context;

    TracingSubscriber(Subscriber<? super T> actual, Context context) {
        super(actual);
        this.wrappedSubscriber = actual;
        this.context = context;
    }

    public void onNext(T t) {
        try (Scope ignored = this.context.makeCurrent();){
            this.wrappedSubscriber.onNext(t);
        }
    }

    public void onError(Throwable t) {
        try (Scope ignored = this.context.makeCurrent();){
            this.wrappedSubscriber.onError(t);
        }
    }

    public void onComplete() {
        try (Scope ignored = this.context.makeCurrent();){
            this.wrappedSubscriber.onComplete();
        }
    }

    public int requestFusion(int mode) {
        QueueSubscription qs = this.qs;
        if (qs != null) {
            int m;
            this.sourceMode = m = qs.requestFusion(mode);
            return m;
        }
        return 0;
    }

    public T poll() throws Exception {
        return (T)this.qs.poll();
    }
}

