/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.rxjava.v2_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;

class TracingCompletableObserver
implements CompletableObserver,
Disposable {
    private final CompletableObserver actual;
    private final Context context;
    private Disposable disposable;

    TracingCompletableObserver(CompletableObserver actual, Context context) {
        this.actual = actual;
        this.context = context;
    }

    public void onSubscribe(Disposable d) {
        if (!DisposableHelper.validate((Disposable)this.disposable, (Disposable)d)) {
            return;
        }
        this.disposable = d;
        this.actual.onSubscribe((Disposable)this);
    }

    public void onComplete() {
        try (Scope ignored = this.context.makeCurrent();){
            this.actual.onComplete();
        }
    }

    public void onError(Throwable e) {
        try (Scope ignored = this.context.makeCurrent();){
            this.actual.onError(e);
        }
    }

    public void dispose() {
        this.disposable.dispose();
    }

    public boolean isDisposed() {
        return this.disposable.isDisposed();
    }
}

