/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.rxjava3;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.reactivex.rxjava3.internal.fuseable.ConditionalSubscriber;
import io.reactivex.rxjava3.internal.fuseable.QueueSubscription;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableConditionalSubscriber;

class TracingConditionalSubscriber<T>
extends BasicFuseableConditionalSubscriber<T, T> {
    private final Context context;

    TracingConditionalSubscriber(ConditionalSubscriber<? super T> downstream, Context context) {
        super(downstream);
        this.context = context;
    }

    public boolean tryOnNext(T t) {
        try (Scope ignored = this.context.makeCurrent();){
            boolean bl = this.downstream.tryOnNext(t);
            return bl;
        }
    }

    public void onNext(T t) {
        try (Scope ignored = this.context.makeCurrent();){
            this.downstream.onNext(t);
        }
    }

    public void onError(Throwable t) {
        try (Scope ignored = this.context.makeCurrent();){
            this.downstream.onError(t);
        }
    }

    public void onComplete() {
        try (Scope ignored = this.context.makeCurrent();){
            this.downstream.onComplete();
        }
    }

    public int requestFusion(int mode) {
        QueueSubscription qs = this.qs;
        if (qs != null) {
            int m;
            this.sourceMode = m = qs.requestFusion(mode);
            return m;
        }
        return 0;
    }

    public T poll() throws Throwable {
        return (T)this.qs.poll();
    }
}

