/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.rxjava3;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.rxjava3.TracingConditionalSubscriber;
import io.opentelemetry.instrumentation.rxjava3.TracingSubscriber;
import io.reactivex.rxjava3.internal.fuseable.ConditionalSubscriber;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import org.reactivestreams.Subscriber;

class TracingParallelFlowable<T>
extends ParallelFlowable<T> {
    private final ParallelFlowable<T> source;
    private final Context context;

    TracingParallelFlowable(ParallelFlowable<T> source, Context context) {
        this.source = source;
        this.context = context;
    }

    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            Subscriber<? super T> z = subscribers[i];
            parents[i] = z instanceof ConditionalSubscriber ? new TracingConditionalSubscriber((ConditionalSubscriber)z, this.context) : new TracingSubscriber<T>(z, this.context);
        }
        try (Scope ignored = this.context.makeCurrent();){
            this.source.subscribe(parents);
        }
    }

    public int parallelism() {
        return this.source.parallelism();
    }
}

