/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.rxjava.v3_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.annotation.support.async.AsyncOperationEndStrategies;
import io.opentelemetry.instrumentation.api.annotation.support.async.AsyncOperationEndStrategy;
import io.opentelemetry.instrumentation.rxjava.v3.common.RxJava3AsyncOperationEndStrategy;
import io.opentelemetry.instrumentation.rxjava.v3.common.TracingCompletableObserver;
import io.opentelemetry.instrumentation.rxjava.v3.common.TracingMaybeObserver;
import io.opentelemetry.instrumentation.rxjava.v3.common.TracingSingleObserver;
import io.opentelemetry.instrumentation.rxjava.v3_0.TracingAssemblyBuilder;
import io.opentelemetry.instrumentation.rxjava.v3_0.TracingConditionalSubscriber;
import io.opentelemetry.instrumentation.rxjava.v3_0.TracingObserver;
import io.opentelemetry.instrumentation.rxjava.v3_0.TracingParallelFlowable;
import io.opentelemetry.instrumentation.rxjava.v3_0.TracingSubscriber;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.fuseable.ConditionalSubscriber;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import javax.annotation.Nullable;
import org.reactivestreams.Subscriber;

public final class TracingAssembly {
    @Nullable
    private static BiFunction<? super Observable, ? super Observer, ? extends Observer> oldOnObservableSubscribe;
    @Nullable
    private static BiFunction<? super Completable, ? super CompletableObserver, ? extends CompletableObserver> oldOnCompletableSubscribe;
    @Nullable
    private static BiFunction<? super Single, ? super SingleObserver, ? extends SingleObserver> oldOnSingleSubscribe;
    @Nullable
    private static BiFunction<? super Maybe, ? super MaybeObserver, ? extends MaybeObserver> oldOnMaybeSubscribe;
    @Nullable
    private static BiFunction<? super Flowable, ? super Subscriber, ? extends Subscriber> oldOnFlowableSubscribe;
    @Nullable
    private static Function<? super ParallelFlowable, ? extends ParallelFlowable> oldOnParallelAssembly;
    private static boolean enabled;
    private final boolean captureExperimentalSpanAttributes;
    private static RxJava3AsyncOperationEndStrategy asyncOperationEndStrategy;

    public static TracingAssembly create() {
        return TracingAssembly.builder().build();
    }

    public static TracingAssemblyBuilder builder() {
        return new TracingAssemblyBuilder();
    }

    TracingAssembly(boolean captureExperimentalSpanAttributes) {
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        Class<TracingAssembly> clazz = TracingAssembly.class;
        synchronized (TracingAssembly.class) {
            if (enabled) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            TracingAssembly.enableObservable();
            TracingAssembly.enableCompletable();
            TracingAssembly.enableSingle();
            TracingAssembly.enableMaybe();
            TracingAssembly.enableFlowable();
            TracingAssembly.enableParallel();
            TracingAssembly.enableWithSpanStrategy(this.captureExperimentalSpanAttributes);
            enabled = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        Class<TracingAssembly> clazz = TracingAssembly.class;
        synchronized (TracingAssembly.class) {
            if (!enabled) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            TracingAssembly.disableObservable();
            TracingAssembly.disableCompletable();
            TracingAssembly.disableSingle();
            TracingAssembly.disableMaybe();
            TracingAssembly.disableFlowable();
            TracingAssembly.disableParallel();
            TracingAssembly.disableWithSpanStrategy();
            enabled = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void enableParallel() {
        oldOnParallelAssembly = RxJavaPlugins.getOnParallelAssembly();
        RxJavaPlugins.setOnParallelAssembly(TracingAssembly.compose(oldOnParallelAssembly, parallelFlowable -> new TracingParallelFlowable(parallelFlowable, Context.current())));
    }

    private static void enableCompletable() {
        oldOnCompletableSubscribe = RxJavaPlugins.getOnCompletableSubscribe();
        RxJavaPlugins.setOnCompletableSubscribe(TracingAssembly.biCompose(oldOnCompletableSubscribe, (completable, observer) -> {
            Context context = Context.current();
            try (Scope ignored = context.makeCurrent();){
                TracingCompletableObserver tracingCompletableObserver = new TracingCompletableObserver(observer, context);
                return tracingCompletableObserver;
            }
        }));
    }

    private static void enableFlowable() {
        oldOnFlowableSubscribe = RxJavaPlugins.getOnFlowableSubscribe();
        RxJavaPlugins.setOnFlowableSubscribe(TracingAssembly.biCompose(oldOnFlowableSubscribe, (flowable, subscriber) -> {
            Context context = Context.current();
            try (Scope ignored = context.makeCurrent();){
                if (subscriber instanceof ConditionalSubscriber) {
                    TracingConditionalSubscriber tracingConditionalSubscriber = new TracingConditionalSubscriber((ConditionalSubscriber)subscriber, context);
                    return tracingConditionalSubscriber;
                }
                TracingSubscriber tracingSubscriber = new TracingSubscriber(subscriber, context);
                return tracingSubscriber;
            }
        }));
    }

    private static void enableObservable() {
        oldOnObservableSubscribe = RxJavaPlugins.getOnObservableSubscribe();
        RxJavaPlugins.setOnObservableSubscribe(TracingAssembly.biCompose(oldOnObservableSubscribe, (observable, observer) -> {
            Context context = Context.current();
            try (Scope ignored = context.makeCurrent();){
                TracingObserver tracingObserver = new TracingObserver(observer, context);
                return tracingObserver;
            }
        }));
    }

    private static void enableSingle() {
        oldOnSingleSubscribe = RxJavaPlugins.getOnSingleSubscribe();
        RxJavaPlugins.setOnSingleSubscribe(TracingAssembly.biCompose(oldOnSingleSubscribe, (single, singleObserver) -> {
            Context context = Context.current();
            try (Scope ignored = context.makeCurrent();){
                TracingSingleObserver tracingSingleObserver = new TracingSingleObserver(singleObserver, context);
                return tracingSingleObserver;
            }
        }));
    }

    private static void enableMaybe() {
        oldOnMaybeSubscribe = RxJavaPlugins.getOnMaybeSubscribe();
        RxJavaPlugins.setOnMaybeSubscribe(TracingAssembly.biCompose(oldOnMaybeSubscribe, (maybe, maybeObserver) -> {
            Context context = Context.current();
            try (Scope ignored = context.makeCurrent();){
                TracingMaybeObserver tracingMaybeObserver = new TracingMaybeObserver(maybeObserver, context);
                return tracingMaybeObserver;
            }
        }));
    }

    private static void enableWithSpanStrategy(boolean captureExperimentalSpanAttributes) {
        asyncOperationEndStrategy = RxJava3AsyncOperationEndStrategy.builder().setCaptureExperimentalSpanAttributes(captureExperimentalSpanAttributes).build();
        AsyncOperationEndStrategies.instance().registerStrategy((AsyncOperationEndStrategy)asyncOperationEndStrategy);
    }

    private static void disableParallel() {
        RxJavaPlugins.setOnParallelAssembly(oldOnParallelAssembly);
        oldOnParallelAssembly = null;
    }

    private static void disableObservable() {
        RxJavaPlugins.setOnObservableSubscribe(oldOnObservableSubscribe);
        oldOnObservableSubscribe = null;
    }

    private static void disableCompletable() {
        RxJavaPlugins.setOnCompletableSubscribe(oldOnCompletableSubscribe);
        oldOnCompletableSubscribe = null;
    }

    private static void disableFlowable() {
        RxJavaPlugins.setOnFlowableSubscribe(oldOnFlowableSubscribe);
        oldOnFlowableSubscribe = null;
    }

    private static void disableSingle() {
        RxJavaPlugins.setOnSingleSubscribe(oldOnSingleSubscribe);
        oldOnSingleSubscribe = null;
    }

    private static void disableMaybe() {
        RxJavaPlugins.setOnMaybeSubscribe(oldOnMaybeSubscribe);
        oldOnMaybeSubscribe = null;
    }

    private static void disableWithSpanStrategy() {
        if (asyncOperationEndStrategy != null) {
            AsyncOperationEndStrategies.instance().unregisterStrategy((AsyncOperationEndStrategy)asyncOperationEndStrategy);
            asyncOperationEndStrategy = null;
        }
    }

    private static <T> Function<? super T, ? extends T> compose(Function<? super T, ? extends T> before, Function<? super T, ? extends T> after) {
        if (before == null) {
            return after;
        }
        return v -> after.apply(before.apply(v));
    }

    private static <T, U> BiFunction<? super T, ? super U, ? extends U> biCompose(BiFunction<? super T, ? super U, ? extends U> before, BiFunction<? super T, ? super U, ? extends U> after) {
        if (before == null) {
            return after;
        }
        return (v, u) -> after.apply(v, before.apply(v, u));
    }
}

