/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.rxjava.v3_1_1;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.internal.observers.BasicFuseableObserver;
import io.reactivex.rxjava3.operators.QueueDisposable;

class TracingObserver<T>
extends BasicFuseableObserver<T, T> {
    private final Context context;

    TracingObserver(Observer<? super T> downstream, Context context) {
        super(downstream);
        this.context = context;
    }

    public void onNext(T t) {
        try (Scope ignored = this.context.makeCurrent();){
            this.downstream.onNext(t);
        }
    }

    public void onError(Throwable t) {
        try (Scope ignored = this.context.makeCurrent();){
            this.downstream.onError(t);
        }
    }

    public void onComplete() {
        try (Scope ignored = this.context.makeCurrent();){
            this.downstream.onComplete();
        }
    }

    public int requestFusion(int mode) {
        QueueDisposable qd = this.qd;
        if (qd != null) {
            int m;
            this.sourceMode = m = qd.requestFusion(mode);
            return m;
        }
        return 0;
    }

    public T poll() throws Throwable {
        return (T)this.qd.poll();
    }
}

