/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.servlet.v3_0;

import io.opentelemetry.instrumentation.servlet.ServletAsyncListener;
import io.opentelemetry.instrumentation.servlet.javax.JavaxServletAccessor;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Servlet3Accessor
extends JavaxServletAccessor<HttpServletResponse> {
    public static final Servlet3Accessor INSTANCE = new Servlet3Accessor();

    private Servlet3Accessor() {
    }

    public Integer getRequestRemotePort(HttpServletRequest request) {
        return request.getRemotePort();
    }

    public void addRequestAsyncListener(HttpServletRequest request, ServletAsyncListener<HttpServletResponse> listener, Object response) {
        if (response instanceof HttpServletResponse) {
            request.getAsyncContext().addListener((AsyncListener)new Listener(listener), (ServletRequest)request, (ServletResponse)((HttpServletResponse)response));
        }
    }

    public int getResponseStatus(HttpServletResponse response) {
        return response.getStatus();
    }

    public String getResponseHeader(HttpServletResponse response, String name) {
        return response.getHeader(name);
    }

    public boolean isResponseCommitted(HttpServletResponse response) {
        return response.isCommitted();
    }

    private static class Listener
    implements AsyncListener {
        private final ServletAsyncListener<HttpServletResponse> listener;

        private Listener(ServletAsyncListener<HttpServletResponse> listener) {
            this.listener = listener;
        }

        public void onComplete(AsyncEvent event) {
            this.listener.onComplete((Object)((HttpServletResponse)event.getSuppliedResponse()));
        }

        public void onTimeout(AsyncEvent event) {
            this.listener.onTimeout(event.getAsyncContext().getTimeout());
        }

        public void onError(AsyncEvent event) {
            this.listener.onError(event.getThrowable(), (Object)((HttpServletResponse)event.getSuppliedResponse()));
        }

        public void onStartAsync(AsyncEvent event) {
            event.getAsyncContext().addListener((AsyncListener)this);
        }
    }
}

