/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.servlet.jakarta.v5_0;

import io.opentelemetry.instrumentation.servlet.ServletAccessor;
import io.opentelemetry.instrumentation.servlet.ServletAsyncListener;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.Principal;

public class JakartaServletAccessor
implements ServletAccessor<HttpServletRequest, HttpServletResponse> {
    public static final JakartaServletAccessor INSTANCE = new JakartaServletAccessor();

    private JakartaServletAccessor() {
    }

    public String getRequestContextPath(HttpServletRequest request) {
        return request.getContextPath();
    }

    public String getRequestScheme(HttpServletRequest request) {
        return request.getScheme();
    }

    public String getRequestServerName(HttpServletRequest request) {
        return request.getServerName();
    }

    public int getRequestServerPort(HttpServletRequest request) {
        return request.getServerPort();
    }

    public String getRequestUri(HttpServletRequest request) {
        return request.getRequestURI();
    }

    public String getRequestQueryString(HttpServletRequest request) {
        return request.getQueryString();
    }

    public Object getRequestAttribute(HttpServletRequest request, String name) {
        return request.getAttribute(name);
    }

    public void setRequestAttribute(HttpServletRequest request, String name, Object value) {
        request.setAttribute(name, value);
    }

    public String getRequestProtocol(HttpServletRequest request) {
        return request.getProtocol();
    }

    public String getRequestMethod(HttpServletRequest request) {
        return request.getMethod();
    }

    public String getRequestRemoteAddr(HttpServletRequest request) {
        return request.getRemoteAddr();
    }

    public String getRequestHeader(HttpServletRequest request, String name) {
        return request.getHeader(name);
    }

    public String getRequestServletPath(HttpServletRequest request) {
        return request.getServletPath();
    }

    public String getRequestPathInfo(HttpServletRequest request) {
        return request.getPathInfo();
    }

    public Principal getRequestUserPrincipal(HttpServletRequest request) {
        return request.getUserPrincipal();
    }

    public Integer getRequestRemotePort(HttpServletRequest request) {
        return request.getRemotePort();
    }

    public void addRequestAsyncListener(HttpServletRequest request, ServletAsyncListener<HttpServletResponse> listener, Object response) {
        if (response instanceof HttpServletResponse) {
            request.getAsyncContext().addListener((AsyncListener)new Listener(listener), (ServletRequest)request, (ServletResponse)((HttpServletResponse)response));
        }
    }

    public int getResponseStatus(HttpServletResponse response) {
        return response.getStatus();
    }

    public boolean isResponseCommitted(HttpServletResponse response) {
        return response.isCommitted();
    }

    public boolean isServletException(Throwable throwable) {
        return throwable instanceof ServletException;
    }

    private static class Listener
    implements AsyncListener {
        private final ServletAsyncListener<HttpServletResponse> listener;

        private Listener(ServletAsyncListener<HttpServletResponse> listener) {
            this.listener = listener;
        }

        public void onComplete(AsyncEvent event) {
            this.listener.onComplete((Object)((HttpServletResponse)event.getSuppliedResponse()));
        }

        public void onTimeout(AsyncEvent event) {
            this.listener.onTimeout(event.getAsyncContext().getTimeout());
        }

        public void onError(AsyncEvent event) {
            this.listener.onError(event.getThrowable(), (Object)((HttpServletResponse)event.getSuppliedResponse()));
        }

        public void onStartAsync(AsyncEvent event) {
            event.getAsyncContext().addListener((AsyncListener)this);
        }
    }
}

