/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.servlet.jakarta.v5_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.servlet.MappingResolver;
import io.opentelemetry.instrumentation.api.servlet.ServerSpanNaming;
import io.opentelemetry.instrumentation.servlet.ServletAccessor;
import io.opentelemetry.instrumentation.servlet.ServletHttpServerTracer;
import io.opentelemetry.instrumentation.servlet.jakarta.v5_0.JakartaHttpServletRequestGetter;
import io.opentelemetry.instrumentation.servlet.jakarta.v5_0.JakartaServletAccessor;
import io.opentelemetry.instrumentation.servlet.naming.ServletSpanNameProvider;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public class JakartaServletHttpServerTracer
extends ServletHttpServerTracer<HttpServletRequest, HttpServletResponse> {
    private static final JakartaServletHttpServerTracer TRACER = new JakartaServletHttpServerTracer();
    private static final ServletSpanNameProvider<HttpServletRequest> SPAN_NAME_PROVIDER = new ServletSpanNameProvider((ServletAccessor)JakartaServletAccessor.INSTANCE);

    public JakartaServletHttpServerTracer() {
        super((ServletAccessor)JakartaServletAccessor.INSTANCE);
    }

    public static JakartaServletHttpServerTracer tracer() {
        return TRACER;
    }

    public Context startSpan(HttpServletRequest request, MappingResolver mappingResolver, boolean servlet) {
        return this.startSpan(request, SPAN_NAME_PROVIDER.getSpanName(mappingResolver, (Object)request), servlet);
    }

    public Context updateContext(Context context, HttpServletRequest request, MappingResolver mappingResolver, boolean servlet) {
        ServerSpanNaming.updateServerSpanName((Context)context, (ServerSpanNaming.Source)(servlet ? ServerSpanNaming.Source.SERVLET : ServerSpanNaming.Source.FILTER), () -> SPAN_NAME_PROVIDER.getSpanNameOrNull(mappingResolver, (Object)request));
        return this.updateContext(context, request);
    }

    protected String getInstrumentationName() {
        return "io.opentelemetry.servlet-5.0";
    }

    protected TextMapGetter<HttpServletRequest> getGetter() {
        return JakartaHttpServletRequestGetter.GETTER;
    }

    protected String errorExceptionAttributeName() {
        return "jakarta.servlet.error.exception";
    }
}

