/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.servlet;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.servlet.AppServerBridge;
import io.opentelemetry.instrumentation.api.servlet.ServletContextPath;
import io.opentelemetry.instrumentation.api.servlet.ServletSpanNaming;
import io.opentelemetry.instrumentation.api.tracer.HttpServerTracer;
import io.opentelemetry.instrumentation.servlet.ServletAccessor;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServletHttpServerTracer<REQUEST, RESPONSE>
extends HttpServerTracer<REQUEST, RESPONSE, REQUEST, REQUEST> {
    private static final Logger log = LoggerFactory.getLogger(ServletHttpServerTracer.class);
    private static final boolean CAPTURE_EXPERIMENTAL_SPAN_ATTRIBUTES = Config.get().getBooleanProperty("otel.instrumentation.servlet.experimental-span-attributes", false);
    private final ServletAccessor<REQUEST, RESPONSE> accessor;

    public ServletHttpServerTracer(ServletAccessor<REQUEST, RESPONSE> accessor) {
        this.accessor = accessor;
    }

    public Context startSpan(REQUEST request, String spanName) {
        Context context = this.startSpan(request, request, request, spanName);
        SpanContext spanContext = Span.fromContext((Context)context).getSpanContext();
        this.accessor.setRequestAttribute(request, "trace_id", spanContext.getTraceId());
        this.accessor.setRequestAttribute(request, "span_id", spanContext.getSpanId());
        return this.addServletContextPath(context, request);
    }

    protected Context customizeContext(Context context, REQUEST request) {
        context = ServletSpanNaming.init((Context)context);
        return this.addServletContextPath(context, request);
    }

    private Context addServletContextPath(Context context, REQUEST request) {
        String contextPath = this.accessor.getRequestContextPath(request);
        if (contextPath != null && !contextPath.isEmpty() && !contextPath.equals("/")) {
            return context.with(ServletContextPath.CONTEXT_KEY, (Object)contextPath);
        }
        return context;
    }

    public void endExceptionally(Context context, Throwable throwable, RESPONSE response, long timestamp) {
        if (this.accessor.isResponseCommitted(response)) {
            super.endExceptionally(context, throwable, response, timestamp);
        } else {
            super.endExceptionally(context, throwable, null, timestamp);
        }
    }

    protected String url(REQUEST httpServletRequest) {
        try {
            return new URI(this.accessor.getRequestScheme(httpServletRequest), null, this.accessor.getRequestServerName(httpServletRequest), this.accessor.getRequestServerPort(httpServletRequest), this.accessor.getRequestUri(httpServletRequest), this.accessor.getRequestQueryString(httpServletRequest), null).toString();
        }
        catch (URISyntaxException e) {
            log.debug("Failed to construct request URI", (Throwable)e);
            return null;
        }
    }

    public Context getServerContext(REQUEST request) {
        Object context = this.accessor.getRequestAttribute(request, CONTEXT_ATTRIBUTE);
        return context instanceof Context ? (Context)context : null;
    }

    protected void attachServerContext(Context context, REQUEST request) {
        this.accessor.setRequestAttribute(request, CONTEXT_ATTRIBUTE, context);
    }

    protected Integer peerPort(REQUEST connection) {
        return this.accessor.getRequestRemotePort(connection);
    }

    protected String peerHostIP(REQUEST connection) {
        return this.accessor.getRequestRemoteAddr(connection);
    }

    protected String method(REQUEST request) {
        return this.accessor.getRequestMethod(request);
    }

    protected int responseStatus(RESPONSE response) {
        return this.accessor.getResponseStatus(response);
    }

    protected abstract TextMapGetter<REQUEST> getGetter();

    public ServletAccessor<REQUEST, RESPONSE> getServletAccessor() {
        return this.accessor;
    }

    public void addUnwrappedThrowable(Context context, Throwable throwable) {
        if (AppServerBridge.shouldRecordException((Context)context)) {
            this.onException(context, throwable);
        }
    }

    protected Throwable unwrapThrowable(Throwable throwable) {
        if (this.accessor.isServletException(throwable) && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return super.unwrapThrowable(throwable);
    }

    public void setPrincipal(Context context, REQUEST request) {
        Principal principal = this.accessor.getRequestUserPrincipal(request);
        if (principal != null) {
            Span.fromContext((Context)context).setAttribute(SemanticAttributes.ENDUSER_ID, (Object)principal.getName());
        }
    }

    protected String flavor(REQUEST connection, REQUEST request) {
        return this.accessor.getRequestProtocol(connection);
    }

    protected String requestHeader(REQUEST httpServletRequest, String name) {
        return this.accessor.getRequestHeader(httpServletRequest, name);
    }

    public Throwable errorException(REQUEST request) {
        Object value = this.accessor.getRequestAttribute(request, this.errorExceptionAttributeName());
        if (value instanceof Throwable) {
            return (Throwable)value;
        }
        return null;
    }

    protected abstract String errorExceptionAttributeName();

    public String getSpanName(REQUEST request) {
        String servletPath = this.accessor.getRequestServletPath(request);
        if (servletPath.isEmpty()) {
            return "HTTP " + this.accessor.getRequestMethod(request);
        }
        String contextPath = this.accessor.getRequestContextPath(request);
        if (contextPath == null || contextPath.isEmpty() || contextPath.equals("/")) {
            return servletPath;
        }
        return contextPath + servletPath;
    }

    public Context updateContext(Context context, REQUEST request) {
        String contextPath = (String)context.get(ServletContextPath.CONTEXT_KEY);
        if (contextPath == null) {
            context = this.addServletContextPath(context, request);
        }
        return context;
    }

    public void updateSpanName(REQUEST request) {
        this.updateSpanName(this.getServerSpan(request), request);
    }

    private void updateSpanName(Span span, REQUEST request) {
        span.updateName(this.getSpanName(request));
    }

    public void onTimeout(Context context, long timeout) {
        Span span = Span.fromContext((Context)context);
        span.setStatus(StatusCode.ERROR);
        if (CAPTURE_EXPERIMENTAL_SPAN_ATTRIBUTES) {
            span.setAttribute("servlet.timeout", timeout);
        }
        span.end();
    }

    public boolean needsRescoping(Context attachedContext) {
        return !ServletHttpServerTracer.sameTrace(Span.fromContext((Context)Context.current()), Span.fromContext((Context)attachedContext));
    }

    private static boolean sameTrace(Span oneSpan, Span otherSpan) {
        return oneSpan.getSpanContext().getTraceId().equals(otherSpan.getSpanContext().getTraceId());
    }
}

