/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.servlet;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.servlet.ServletAsyncListener;
import io.opentelemetry.instrumentation.servlet.ServletHttpServerTracer;
import java.util.concurrent.atomic.AtomicBoolean;

public class TagSettingAsyncListener<REQUEST, RESPONSE>
implements ServletAsyncListener<RESPONSE> {
    private final ServletHttpServerTracer<REQUEST, RESPONSE> tracer;
    private final AtomicBoolean responseHandled;
    private final Context context;

    public TagSettingAsyncListener(ServletHttpServerTracer<REQUEST, RESPONSE> tracer, AtomicBoolean responseHandled, Context context) {
        this.tracer = tracer;
        this.responseHandled = responseHandled;
        this.context = context;
    }

    @Override
    public void onComplete(RESPONSE response) {
        if (this.responseHandled.compareAndSet(false, true)) {
            this.tracer.end(this.context, response);
        }
    }

    @Override
    public void onTimeout(long timeout) {
        if (this.responseHandled.compareAndSet(false, true)) {
            this.tracer.onTimeout(this.context, timeout);
        }
    }

    @Override
    public void onError(Throwable throwable, RESPONSE response) {
        if (this.responseHandled.compareAndSet(false, true)) {
            this.tracer.endExceptionally(this.context, throwable, response);
        }
    }
}

