/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.servlet.naming;

import io.opentelemetry.instrumentation.api.servlet.MappingResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public abstract class ServletFilterMappingResolverFactory<FILTERREGISTRATION> {
    protected abstract FILTERREGISTRATION getFilterRegistration();

    protected abstract Collection<String> getUrlPatternMappings(FILTERREGISTRATION var1);

    protected abstract Collection<String> getServletNameMappings(FILTERREGISTRATION var1);

    protected abstract Collection<String> getServletMappings(String var1);

    private Collection<String> getMappings() {
        Collection<String> servletNameMappings;
        FILTERREGISTRATION filterRegistration = this.getFilterRegistration();
        if (filterRegistration == null) {
            return null;
        }
        HashSet<String> mappings = new HashSet<String>();
        Collection<String> urlPatternMappings = this.getUrlPatternMappings(filterRegistration);
        if (urlPatternMappings != null) {
            mappings.addAll(urlPatternMappings);
        }
        if ((servletNameMappings = this.getServletNameMappings(filterRegistration)) != null) {
            for (String servletName : servletNameMappings) {
                Collection<String> servletMappings = this.getServletMappings(servletName);
                if (servletMappings == null) continue;
                mappings.addAll(servletMappings);
            }
        }
        if (mappings.isEmpty()) {
            return null;
        }
        ArrayList<String> mappingsList = new ArrayList<String>(mappings);
        Collections.sort(mappingsList, (s1, s2) -> s2.length() - s1.length());
        return mappingsList;
    }

    public final MappingResolver create() {
        Collection<String> mappings = this.getMappings();
        if (mappings == null) {
            return null;
        }
        return MappingResolver.build(mappings);
    }
}

