/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.servlet.naming;

import io.opentelemetry.instrumentation.api.servlet.MappingResolver;
import io.opentelemetry.instrumentation.servlet.ServletAccessor;

public class ServletSpanNameProvider<REQUEST> {
    private final ServletAccessor<REQUEST, ?> servletAccessor;

    public ServletSpanNameProvider(ServletAccessor<REQUEST, ?> servletAccessor) {
        this.servletAccessor = servletAccessor;
    }

    public String getSpanName(MappingResolver mappingResolver, REQUEST request) {
        String spanName = this.getSpanNameOrNull(mappingResolver, request);
        if (spanName == null) {
            String contextPath = this.servletAccessor.getRequestContextPath(request);
            if (contextPath == null || contextPath.isEmpty() || contextPath.equals("/")) {
                return "HTTP " + this.servletAccessor.getRequestMethod(request);
            }
            return contextPath + "/*";
        }
        return spanName;
    }

    public String getSpanNameOrNull(MappingResolver mappingResolver, REQUEST request) {
        String pathInfo;
        if (mappingResolver == null) {
            return null;
        }
        String servletPath = this.servletAccessor.getRequestServletPath(request);
        String mapping = mappingResolver.resolve(servletPath, pathInfo = this.servletAccessor.getRequestPathInfo(request));
        if (mapping == null) {
            return null;
        }
        String contextPath = this.servletAccessor.getRequestContextPath(request);
        if (contextPath == null || contextPath.isEmpty() || contextPath.equals("/")) {
            return mapping;
        }
        return contextPath + mapping;
    }
}

