/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.propagators;

import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.contrib.awsxray.propagator.AwsXrayPropagator;
import io.opentelemetry.extension.trace.propagation.B3Propagator;
import io.opentelemetry.extension.trace.propagation.JaegerPropagator;
import io.opentelemetry.extension.trace.propagation.OtTracePropagator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.util.ClassUtils;

public final class CompositeTextMapPropagatorFactory {
    private static final Logger logger = Logger.getLogger(CompositeTextMapPropagatorFactory.class.getName());

    static TextMapPropagator getCompositeTextMapPropagator(BeanFactory beanFactory, List<String> types) {
        HashSet<Object> propagators = new HashSet<Object>();
        Iterator<String> iterator = types.iterator();
        block18: while (iterator.hasNext()) {
            String type;
            switch (type = iterator.next()) {
                case "b3": {
                    if (!CompositeTextMapPropagatorFactory.isOnClasspath("io.opentelemetry.extension.trace.propagation.B3Propagator")) continue block18;
                    propagators.add((TextMapPropagator)beanFactory.getBeanProvider(B3Propagator.class).getIfAvailable(B3Propagator::injectingSingleHeader));
                    continue block18;
                }
                case "b3multi": {
                    if (!CompositeTextMapPropagatorFactory.isOnClasspath("io.opentelemetry.extension.trace.propagation.B3Propagator")) continue block18;
                    propagators.add((TextMapPropagator)beanFactory.getBeanProvider(B3Propagator.class).getIfAvailable(B3Propagator::injectingMultiHeaders));
                    continue block18;
                }
                case "jaeger": {
                    if (!CompositeTextMapPropagatorFactory.isOnClasspath("io.opentelemetry.extension.trace.propagation.JaegerPropagator")) continue block18;
                    propagators.add((TextMapPropagator)beanFactory.getBeanProvider(JaegerPropagator.class).getIfAvailable(JaegerPropagator::getInstance));
                    continue block18;
                }
                case "ottrace": {
                    if (!CompositeTextMapPropagatorFactory.isOnClasspath("io.opentelemetry.extension.trace.propagation.OtTracerPropagator")) continue block18;
                    propagators.add((TextMapPropagator)beanFactory.getBeanProvider(OtTracePropagator.class).getIfAvailable(OtTracePropagator::getInstance));
                    continue block18;
                }
                case "xray": {
                    if (!CompositeTextMapPropagatorFactory.isOnClasspath("io.opentelemetry.contrib.awsxray.AwsXrayPropagator")) continue block18;
                    propagators.add((TextMapPropagator)beanFactory.getBeanProvider(AwsXrayPropagator.class).getIfAvailable(AwsXrayPropagator::getInstance));
                    continue block18;
                }
                case "tracecontext": {
                    propagators.add(W3CTraceContextPropagator.getInstance());
                    continue block18;
                }
                case "baggage": {
                    propagators.add(W3CBaggagePropagator.getInstance());
                    continue block18;
                }
            }
            logger.log(Level.WARNING, "Unsupported type of propagator: {0}", type);
        }
        return TextMapPropagator.composite(propagators);
    }

    private static boolean isOnClasspath(String clazz) {
        return ClassUtils.isPresent((String)clazz, null);
    }

    private CompositeTextMapPropagatorFactory() {
    }
}

