/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.instrumentation.spring.autoconfigure.MetricExportProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.OpenTelemetryInjector;
import io.opentelemetry.instrumentation.spring.autoconfigure.SamplerProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.resources.SpringResourceConfigProperties;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.logs.SdkLoggerProviderBuilder;
import io.opentelemetry.sdk.logs.export.BatchLogRecordProcessor;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReaderBuilder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

@Configuration
@EnableConfigurationProperties(value={MetricExportProperties.class, SamplerProperties.class})
public class OpenTelemetryAutoConfiguration {

    @Configuration
    @ConditionalOnMissingBean(value={OpenTelemetry.class})
    @ConditionalOnProperty(name={"otel.sdk.disabled"}, havingValue="true")
    public static class DisabledOpenTelemetrySdkConfig {
        @Bean
        public OpenTelemetry openTelemetry() {
            return OpenTelemetry.noop();
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={OpenTelemetry.class})
    @ConditionalOnProperty(name={"otel.sdk.disabled"}, havingValue="false", matchIfMissing=true)
    public static class OpenTelemetrySdkConfig {
        @Bean
        @ConditionalOnMissingBean
        public SdkTracerProvider sdkTracerProvider(SamplerProperties samplerProperties, ObjectProvider<List<SpanExporter>> spanExportersProvider, Resource otelResource) {
            SdkTracerProviderBuilder tracerProviderBuilder = SdkTracerProvider.builder();
            ((List)spanExportersProvider.getIfAvailable(Collections::emptyList)).stream().map(spanExporter -> BatchSpanProcessor.builder((SpanExporter)spanExporter).build()).forEach(arg_0 -> ((SdkTracerProviderBuilder)tracerProviderBuilder).addSpanProcessor(arg_0));
            return tracerProviderBuilder.setResource(otelResource).setSampler(Sampler.traceIdRatioBased((double)samplerProperties.getProbability())).build();
        }

        @Bean
        @ConditionalOnMissingBean
        public SdkLoggerProvider sdkLoggerProvider(ObjectProvider<List<LogRecordExporter>> loggerExportersProvider, Resource otelResource) {
            SdkLoggerProviderBuilder loggerProviderBuilder = SdkLoggerProvider.builder();
            loggerProviderBuilder.setResource(otelResource);
            ((List)loggerExportersProvider.getIfAvailable(Collections::emptyList)).forEach(loggerExporter -> loggerProviderBuilder.addLogRecordProcessor((LogRecordProcessor)BatchLogRecordProcessor.builder((LogRecordExporter)loggerExporter).build()));
            return loggerProviderBuilder.build();
        }

        @Bean
        @ConditionalOnMissingBean
        public SdkMeterProvider sdkMeterProvider(MetricExportProperties properties, ObjectProvider<List<MetricExporter>> metricExportersProvider, Resource otelResource) {
            SdkMeterProviderBuilder meterProviderBuilder = SdkMeterProvider.builder();
            ((List)metricExportersProvider.getIfAvailable(Collections::emptyList)).stream().map(metricExporter -> OpenTelemetrySdkConfig.createPeriodicMetricReader(properties, metricExporter)).forEach(arg_0 -> ((SdkMeterProviderBuilder)meterProviderBuilder).registerMetricReader(arg_0));
            return meterProviderBuilder.setResource(otelResource).build();
        }

        private static PeriodicMetricReader createPeriodicMetricReader(MetricExportProperties properties, MetricExporter metricExporter) {
            PeriodicMetricReaderBuilder metricReaderBuilder = PeriodicMetricReader.builder((MetricExporter)metricExporter);
            if (properties.getInterval() != null) {
                metricReaderBuilder.setInterval(properties.getInterval());
            }
            return metricReaderBuilder.build();
        }

        @Bean
        @ConditionalOnMissingBean
        public Resource otelResource(Environment env, ObjectProvider<List<ResourceProvider>> resourceProviders) {
            SpringResourceConfigProperties config = new SpringResourceConfigProperties(env, (ExpressionParser)new SpelExpressionParser());
            Resource resource = Resource.getDefault();
            for (ResourceProvider resourceProvider : (List)resourceProviders.getIfAvailable(Collections::emptyList)) {
                resource = resource.merge(resourceProvider.createResource((ConfigProperties)config));
            }
            return resource;
        }

        @Bean
        public OpenTelemetry openTelemetry(ObjectProvider<ContextPropagators> propagatorsProvider, SdkTracerProvider tracerProvider, SdkMeterProvider meterProvider, SdkLoggerProvider loggerProvider, ObjectProvider<List<OpenTelemetryInjector>> openTelemetryConsumerProvider) {
            ContextPropagators propagators = (ContextPropagators)propagatorsProvider.getIfAvailable(ContextPropagators::noop);
            OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).setMeterProvider(meterProvider).setLoggerProvider(loggerProvider).setPropagators(propagators).build();
            List openTelemetryInjectors = (List)openTelemetryConsumerProvider.getIfAvailable(() -> Collections.emptyList());
            openTelemetryInjectors.forEach(consumer -> consumer.accept(openTelemetry));
            return openTelemetry;
        }
    }
}

