/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.instrumentation.webflux;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.SpringWebfluxTelemetry;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.web.reactive.function.client.WebClient;

final class WebClientBeanPostProcessor
implements BeanPostProcessor {
    private final OpenTelemetry openTelemetry;

    WebClientBeanPostProcessor(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof WebClient) {
            WebClient webClient = (WebClient)bean;
            return this.wrapBuilder(webClient.mutate()).build();
        }
        if (bean instanceof WebClient.Builder) {
            WebClient.Builder webClientBuilder = (WebClient.Builder)bean;
            return this.wrapBuilder(webClientBuilder);
        }
        return bean;
    }

    private WebClient.Builder wrapBuilder(WebClient.Builder webClientBuilder) {
        SpringWebfluxTelemetry instrumentation = SpringWebfluxTelemetry.create((OpenTelemetry)this.openTelemetry);
        return webClientBuilder.filters(arg_0 -> ((SpringWebfluxTelemetry)instrumentation).addClientTracingFilter(arg_0));
    }
}

