/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.web.v3_1;

import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpResponse;

enum SpringWebHttpAttributesGetter implements HttpClientAttributesGetter<HttpRequest, ClientHttpResponse>
{
    INSTANCE;

    @Nullable
    private static final MethodHandle GET_STATUS_CODE;
    @Nullable
    private static final MethodHandle STATUS_CODE_VALUE;

    public String getMethod(HttpRequest httpRequest) {
        return httpRequest.getMethod().name();
    }

    @Nullable
    public String getUrl(HttpRequest httpRequest) {
        return httpRequest.getURI().toString();
    }

    public List<String> getRequestHeader(HttpRequest httpRequest, String name) {
        return (List)httpRequest.getHeaders().getOrDefault((Object)name, Collections.emptyList());
    }

    @Nullable
    public String getFlavor(HttpRequest httpRequest, @Nullable ClientHttpResponse clientHttpResponse) {
        return null;
    }

    public Integer getStatusCode(HttpRequest httpRequest, ClientHttpResponse clientHttpResponse, @Nullable Throwable error) {
        if (GET_STATUS_CODE == null || STATUS_CODE_VALUE == null) {
            return null;
        }
        try {
            Object statusCode = GET_STATUS_CODE.invoke(clientHttpResponse);
            return STATUS_CODE_VALUE.invoke(statusCode);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public List<String> getResponseHeader(HttpRequest httpRequest, ClientHttpResponse clientHttpResponse, String name) {
        return (List)clientHttpResponse.getHeaders().getOrDefault((Object)name, Collections.emptyList());
    }

    static {
        MethodHandle getStatusCode = null;
        MethodHandle statusCodeValue = null;
        Class<?> httpStatusCodeClass = null;
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        try {
            httpStatusCodeClass = Class.forName("org.springframework.http.HttpStatusCode");
        }
        catch (ClassNotFoundException e) {
            try {
                httpStatusCodeClass = Class.forName("org.springframework.http.HttpStatus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (httpStatusCodeClass != null) {
            try {
                getStatusCode = lookup.findVirtual(ClientHttpResponse.class, "getStatusCode", MethodType.methodType(httpStatusCodeClass));
                statusCodeValue = lookup.findVirtual(httpStatusCodeClass, "value", MethodType.methodType(Integer.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        GET_STATUS_CODE = getStatusCode;
        STATUS_CODE_VALUE = statusCodeValue;
    }
}

