/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.viburdbcp.v11_0;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbConnectionPoolMetrics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.vibur.dbcp.ViburDBCPDataSource;

final class ConnectionPoolMetrics {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.vibur-dbcp-11.0";
    private static final Map<ViburDBCPDataSource, BatchCallback> dataSourceMetrics = new ConcurrentHashMap<ViburDBCPDataSource, BatchCallback>();

    public static void registerMetrics(OpenTelemetry openTelemetry, ViburDBCPDataSource dataSource) {
        dataSourceMetrics.computeIfAbsent(dataSource, unused -> ConnectionPoolMetrics.createMeters(openTelemetry, dataSource));
    }

    private static BatchCallback createMeters(OpenTelemetry openTelemetry, ViburDBCPDataSource dataSource) {
        DbConnectionPoolMetrics metrics = DbConnectionPoolMetrics.create((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (String)dataSource.getName());
        ObservableLongMeasurement connections = metrics.connections();
        ObservableLongMeasurement maxConnections = metrics.maxConnections();
        Attributes attributes = metrics.getAttributes();
        Attributes usedConnectionsAttributes = metrics.getUsedConnectionsAttributes();
        Attributes idleConnectionsAttributes = metrics.getIdleConnectionsAttributes();
        return metrics.batchCallback(() -> {
            connections.record((long)dataSource.getPool().taken(), usedConnectionsAttributes);
            connections.record((long)dataSource.getPool().remainingCreated(), idleConnectionsAttributes);
            maxConnections.record((long)dataSource.getPoolMaxSize(), attributes);
        }, (ObservableMeasurement)connections, new ObservableMeasurement[]{maxConnections});
    }

    public static void unregisterMetrics(ViburDBCPDataSource dataSource) {
        BatchCallback callback = dataSourceMetrics.remove(dataSource);
        if (callback != null) {
            callback.close();
        }
    }

    private ConnectionPoolMetrics() {
    }
}

