/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.jaxrs.v1_0;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.instrumentation.api.CallDepthThreadLocalMap;
import io.opentelemetry.javaagent.instrumentation.jaxrs.v1_0.JaxRsAnnotationsTracer;
import io.opentelemetry.javaagent.tooling.ClassLoaderMatcher;
import io.opentelemetry.javaagent.tooling.TypeInstrumentation;
import io.opentelemetry.javaagent.tooling.bytebuddy.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.tooling.matcher.NameMatchers;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.Path;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class JaxRsAnnotationsInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return ClassLoaderMatcher.hasClassesNamed((String[])new String[]{"javax.ws.rs.Path"});
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.safeHasSuperType((ElementMatcher)ElementMatchers.isAnnotatedWith((ElementMatcher)ElementMatchers.named((String)"javax.ws.rs.Path")).or((ElementMatcher)ElementMatchers.declaresMethod((ElementMatcher)ElementMatchers.isAnnotatedWith((ElementMatcher)ElementMatchers.named((String)"javax.ws.rs.Path")))));
    }

    public Map<? extends ElementMatcher<? super MethodDescription>, String> transformers() {
        return Collections.singletonMap(ElementMatchers.isMethod().and((ElementMatcher)AgentElementMatchers.hasSuperMethod((ElementMatcher)ElementMatchers.isAnnotatedWith((ElementMatcher)NameMatchers.namedOneOf((String[])new String[]{"javax.ws.rs.Path", "javax.ws.rs.DELETE", "javax.ws.rs.GET", "javax.ws.rs.HEAD", "javax.ws.rs.OPTIONS", "javax.ws.rs.POST", "javax.ws.rs.PUT"})))), JaxRsAnnotationsInstrumentation.class.getName() + "$JaxRsAnnotationsAdvice");
    }

    public static class JaxRsAnnotationsAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void nameSpan(@Advice.This Object target, @Advice.Origin Method method, @Advice.Local(value="otelSpan") Span span, @Advice.Local(value="otelScope") Scope scope) {
            if (CallDepthThreadLocalMap.incrementCallDepth(Path.class) > 0) {
                return;
            }
            span = JaxRsAnnotationsTracer.tracer().startSpan(target.getClass(), method);
            scope = span.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void stopSpan(@Advice.Thrown Throwable throwable, @Advice.Local(value="otelSpan") Span span, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            CallDepthThreadLocalMap.reset(Path.class);
            scope.close();
            if (throwable == null) {
                JaxRsAnnotationsTracer.tracer().end(span);
            } else {
                JaxRsAnnotationsTracer.tracer().endExceptionally(span, throwable);
            }
        }
    }
}

