/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.jaxrs.v1_0;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.servlet.ServletContextPath;
import io.opentelemetry.instrumentation.api.tracer.BaseTracer;
import io.opentelemetry.javaagent.instrumentation.api.WeakMap;
import io.opentelemetry.javaagent.tooling.ClassHierarchyIterable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;

public class JaxRsAnnotationsTracer
extends BaseTracer {
    private static final JaxRsAnnotationsTracer TRACER = new JaxRsAnnotationsTracer();
    private final WeakMap<Class<?>, Map<Method, String>> spanNames = WeakMap.Provider.newWeakMap();

    public static JaxRsAnnotationsTracer tracer() {
        return TRACER;
    }

    public Span startSpan(Class<?> target, Method method) {
        String spanName;
        String pathBasedSpanName = this.getPathSpanName(target, method);
        Context context = Context.current();
        Span serverSpan = BaseTracer.getCurrentServerSpan((Context)context);
        if (serverSpan == null) {
            spanName = pathBasedSpanName;
        } else {
            spanName = this.spanNameForMethod(target, method);
            this.updateServerSpanName(context, serverSpan, pathBasedSpanName);
        }
        return this.tracer.spanBuilder(spanName).startSpan();
    }

    private void updateServerSpanName(Context context, Span span, String spanName) {
        if (!spanName.isEmpty()) {
            span.updateName(ServletContextPath.prepend((Context)context, (String)spanName));
        }
    }

    private String getPathSpanName(Class<?> target, Method method) {
        String spanName;
        Map classMap = (Map)this.spanNames.get(target);
        if (classMap == null) {
            this.spanNames.putIfAbsent(target, new ConcurrentHashMap());
            classMap = (Map)this.spanNames.get(target);
        }
        if ((spanName = (String)classMap.get(method)) == null) {
            String httpMethod = null;
            Path methodPath = null;
            Path classPath = this.findClassPath(target);
            for (Class currentClass : new ClassHierarchyIterable(target)) {
                Method currentMethod = currentClass.equals(target) ? method : this.findMatchingMethod(method, currentClass.getDeclaredMethods());
                if (currentMethod == null) continue;
                if (httpMethod == null) {
                    httpMethod = this.locateHttpMethod(currentMethod);
                }
                if (methodPath == null) {
                    methodPath = this.findMethodPath(currentMethod);
                }
                if (httpMethod == null || methodPath == null) continue;
                break;
            }
            spanName = this.buildSpanName(classPath, methodPath);
            classMap.put(method, spanName);
        }
        return spanName;
    }

    private String locateHttpMethod(Method method) {
        String httpMethod = null;
        for (Annotation ann : method.getDeclaredAnnotations()) {
            if (ann.annotationType().getAnnotation(HttpMethod.class) == null) continue;
            httpMethod = ann.annotationType().getSimpleName();
        }
        return httpMethod;
    }

    private Path findMethodPath(Method method) {
        return method.getAnnotation(Path.class);
    }

    private Path findClassPath(Class<?> target) {
        for (Class currentClass : new ClassHierarchyIterable(target)) {
            Path annotation = currentClass.getAnnotation(Path.class);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    private Method findMatchingMethod(Method baseMethod, Method[] methods) {
        block0: for (Method method : methods) {
            Class<?>[] parameterTypes;
            Class<?>[] baseParameterTypes;
            if (!baseMethod.getReturnType().equals(method.getReturnType()) || !baseMethod.getName().equals(method.getName()) || (baseParameterTypes = baseMethod.getParameterTypes()).length != (parameterTypes = method.getParameterTypes()).length) continue;
            for (int i = 0; i < baseParameterTypes.length; ++i) {
                if (!baseParameterTypes[i].equals(parameterTypes[i])) continue block0;
            }
            return method;
        }
        return null;
    }

    private String buildSpanName(Path classPath, Path methodPath) {
        StringBuilder spanNameBuilder = new StringBuilder();
        boolean skipSlash = false;
        if (classPath != null) {
            if (!classPath.value().startsWith("/")) {
                spanNameBuilder.append("/");
            }
            spanNameBuilder.append(classPath.value());
            skipSlash = classPath.value().endsWith("/");
        }
        if (methodPath != null) {
            String path = methodPath.value();
            if (skipSlash) {
                if (path.startsWith("/")) {
                    path = path.length() == 1 ? "" : path.substring(1);
                }
            } else if (!path.startsWith("/")) {
                spanNameBuilder.append("/");
            }
            spanNameBuilder.append(path);
        }
        String spanName = spanNameBuilder.toString().trim();
        return spanName;
    }

    protected String getInstrumentationName() {
        return "io.opentelemetry.javaagent.jaxrs";
    }
}

