/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.BigendianEncoding;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TraceId {
    private static final ThreadLocal<char[]> charBuffer = new ThreadLocal();
    private static final int SIZE_IN_BYTES = 16;
    private static final int HEX_SIZE = 32;
    private static final String INVALID = "00000000000000000000000000000000";

    private TraceId() {
    }

    public static int getSize() {
        return 16;
    }

    public static int getHexLength() {
        return 32;
    }

    public static String getInvalid() {
        return INVALID;
    }

    public static String fromLongs(long idHi, long idLo) {
        char[] chars = TraceId.getTemporaryBuffer();
        BigendianEncoding.longToBase16String(idHi, chars, 0);
        BigendianEncoding.longToBase16String(idLo, chars, 16);
        return new String(chars);
    }

    private static char[] getTemporaryBuffer() {
        char[] chars = charBuffer.get();
        if (chars == null) {
            chars = new char[32];
            charBuffer.set(chars);
        }
        return chars;
    }

    public static byte[] bytesFromHex(String src, int srcOffset) {
        Objects.requireNonNull(src, "src");
        return BigendianEncoding.bytesFromBase16(src, srcOffset, 32);
    }

    public static void copyHexInto(byte[] traceId, char[] dest, int destOffset) {
        BigendianEncoding.longToBase16String(BigendianEncoding.longFromByteArray(traceId, 0), dest, destOffset);
        BigendianEncoding.longToBase16String(BigendianEncoding.longFromByteArray(traceId, 8), dest, destOffset + 16);
    }

    public static boolean isValid(CharSequence traceId) {
        return traceId.length() == 32 && !INVALID.contentEquals(traceId) && BigendianEncoding.isValidBase16String(traceId);
    }

    public static String bytesToHex(byte[] traceId) {
        char[] chars = new char[32];
        TraceId.copyHexInto(traceId, chars, 0);
        return new String(chars);
    }

    public static long getTraceIdRandomPart(CharSequence traceId) {
        return TraceId.traceIdLowBytesAsLong(traceId);
    }

    public static long traceIdHighBytesAsLong(CharSequence traceId) {
        return BigendianEncoding.longFromBase16String(traceId, 0);
    }

    public static long traceIdLowBytesAsLong(CharSequence traceId) {
        return BigendianEncoding.longFromBase16String(traceId, 16);
    }
}

