/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.oshi;

import com.google.auto.service.AutoService;
import io.opentelemetry.javaagent.extension.AgentListener;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.internal.AutoConfigureUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.lang.reflect.Method;

@AutoService(value={AgentListener.class})
public class OshiMetricsInstaller
implements AgentListener {
    public void afterAgent(AutoConfiguredOpenTelemetrySdk autoConfiguredSdk) {
        boolean defaultEnabled;
        ConfigProperties config = AutoConfigureUtil.getConfig((AutoConfiguredOpenTelemetrySdk)autoConfiguredSdk);
        if (!config.getBoolean("otel.instrumentation.oshi.enabled", defaultEnabled = config.getBoolean("otel.instrumentation.common.default-enabled", true))) {
            return;
        }
        try {
            Class<?> oshiSystemInfoClass = ClassLoader.getSystemClassLoader().loadClass("oshi.SystemInfo");
            Method getCurrentPlatformEnumMethod = OshiMetricsInstaller.getCurrentPlatformMethod(oshiSystemInfoClass);
            getCurrentPlatformEnumMethod.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Method getCurrentPlatformMethod(Class<?> oshiSystemInfoClass) throws NoSuchMethodException {
        try {
            return oshiSystemInfoClass.getMethod("getCurrentPlatformEnum", new Class[0]);
        }
        catch (NoSuchMethodException exception) {
            return oshiSystemInfoClass.getMethod("getCurrentPlatform", new Class[0]);
        }
    }
}

