/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.rmi.context;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContextPayload {
    private static final Logger logger = Logger.getLogger(ContextPayload.class.getName());
    private final Map<String, String> context;

    public ContextPayload() {
        this(new HashMap<String, String>());
    }

    public ContextPayload(Map<String, String> context) {
        this.context = context;
    }

    public static ContextPayload from(Context context) {
        ContextPayload payload = new ContextPayload();
        GlobalOpenTelemetry.getPropagators().getTextMapPropagator().inject(context, (Object)payload, (TextMapSetter)ContextPayloadSetter.INSTANCE);
        return payload;
    }

    public static ContextPayload read(ObjectInput oi) throws IOException {
        try {
            Object object = oi.readObject();
            if (object instanceof Map) {
                Map map = (Map)object;
                return new ContextPayload(map);
            }
        }
        catch (ClassCastException | ClassNotFoundException ex) {
            logger.log(Level.FINE, "Error reading object", ex);
        }
        return null;
    }

    public void write(ObjectOutput out) throws IOException {
        out.writeObject(this.context);
    }

    public Context extract() {
        return GlobalOpenTelemetry.getPropagators().getTextMapPropagator().extract(Context.root(), (Object)this, (TextMapGetter)ContextPayloadGetter.INSTANCE);
    }

    private static enum ContextPayloadSetter implements TextMapSetter<ContextPayload>
    {
        INSTANCE;


        public void set(ContextPayload carrier, String key, String value) {
            carrier.context.put(key, value);
        }
    }

    private static enum ContextPayloadGetter implements TextMapGetter<ContextPayload>
    {
        INSTANCE;


        public Iterable<String> keys(ContextPayload contextPayload) {
            return contextPayload.context.keySet();
        }

        public String get(ContextPayload carrier, String key) {
            return (String)carrier.context.get(key);
        }
    }
}

