/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.rmi.context;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPayload;
import java.io.IOException;
import java.io.ObjectOutput;
import java.rmi.NoSuchObjectException;
import java.rmi.server.ObjID;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.rmi.transport.Connection;
import sun.rmi.transport.StreamRemoteCall;

public class ContextPropagator {
    private static final Logger logger = Logger.getLogger(ContextPropagator.class.getName());
    private static final ObjID ACTIVATOR_ID = new ObjID(1);
    private static final ObjID DGC_ID = new ObjID(2);
    private static final ObjID REGISTRY_ID = new ObjID(0);
    public static final ObjID CONTEXT_CALL_ID = new ObjID("io.opentelemetry.javaagent.context-call".hashCode());
    private static final int CONTEXT_CHECK_CALL_OPERATION_ID = -1;
    private static final int CONTEXT_PAYLOAD_OPERATION_ID = -2;
    public static final ContextPropagator PROPAGATOR = new ContextPropagator();

    public boolean isRmiInternalObject(ObjID id) {
        return ACTIVATOR_ID.equals(id) || DGC_ID.equals(id) || REGISTRY_ID.equals(id);
    }

    public boolean isOperationWithPayload(int operationId) {
        return operationId == -2;
    }

    public void attemptToPropagateContext(VirtualField<Connection, Boolean> knownConnections, Connection c, Context context) {
        if (ContextPropagator.checkIfContextCanBePassed(knownConnections, c) && !ContextPropagator.syntheticCall(c, ContextPayload.from(context), -2)) {
            logger.fine("Couldn't send context payload");
        }
    }

    private static boolean checkIfContextCanBePassed(VirtualField<Connection, Boolean> knownConnections, Connection c) {
        Boolean storedResult = (Boolean)knownConnections.get((Object)c);
        if (storedResult != null) {
            return storedResult;
        }
        boolean result = ContextPropagator.syntheticCall(c, null, -1);
        knownConnections.set((Object)c, (Object)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean syntheticCall(Connection c, ContextPayload payload, int operationId) {
        StreamRemoteCall shareContextCall = new StreamRemoteCall(c);
        try {
            c.getOutputStream().write(80);
            ObjectOutput out = shareContextCall.getOutputStream();
            CONTEXT_CALL_ID.write(out);
            out.writeInt(operationId);
            out.writeLong(operationId);
            if (payload != null) {
                payload.write(out);
            }
            try {
                shareContextCall.executeCall();
                return true;
            }
            catch (Exception e) {
                Exception ex = shareContextCall.getServerException();
                if (ex != null) {
                    if (ex instanceof NoSuchObjectException) {
                        boolean bl = false;
                        return bl;
                    }
                    logger.log(Level.FINE, "Server error when executing synthetic call", ex);
                } else {
                    logger.log(Level.FINE, "Error executing synthetic call", e);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                shareContextCall.done();
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Communication error executing synthetic call", e);
            return false;
        }
    }
}

